/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.file;

import de.ubs.jdbcserver.file.AbstractProcessableFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericFile
extends AbstractProcessableFile {
    private File file;
    private DataInputStream in;
    private DataOutputStream out;

    public GenericFile(File file) throws FileNotFoundException {
        this.file = file;
        this.in = new DataInputStream(new FileInputStream(file));
        this.out = new DataOutputStream(new FileOutputStream(file));
    }

    @Override
    public void close() {
        try {
            this.in.close();
            this.out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(GenericFile.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public boolean isVariableLength() {
        return true;
    }

    @Override
    public int getRecordCount() {
        return -1;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public void updateRecord(byte[] data, int length) throws IOException {
        this.out.writeInt(length);
        this.out.write(data, 0, length);
    }

    @Override
    public void writeRecord(byte[] data, int length) throws IOException {
        this.out.writeShort(length);
        this.out.writeShort(0);
        this.out.write(data, 0, length);
    }

    @Override
    public int readRecord(byte[] data) throws IOException, BufferOverflowException {
        short length = this.in.readShort();
        this.in.readShort();
        this.in.read(data, 0, length);
        return length;
    }

    @Override
    public void deleteLastReadRecord() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getKeyStartOffset() {
        return -1;
    }

    @Override
    public int getKeyLength() {
        return -1;
    }

    @Override
    public int getMaximumRecordLength() {
        return 32768;
    }

    @Override
    public void begin() throws IOException {
        this.in.close();
        this.in = new DataInputStream(new FileInputStream(this.file));
    }

    @Override
    public boolean locate(byte[] data) throws IOException, BufferOverflowException, SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

