/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver;

import de.ubs.jdbcserver.command.UniqueConnectionIdentifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class ScratchPadManager {
    private static ScratchPadManager instance;
    private final Map<Key, Map<Class, List<Object>>> dataMap = new HashMap<Key, Map<Class, List<Object>>>();

    public static synchronized ScratchPadManager getDefault() {
        if (instance == null) {
            instance = new ScratchPadManager();
        }
        return instance;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Key, Map<Class, List<Object>>> entry : this.dataMap.entrySet()) {
            sb.append(entry.getKey()).append(" = ").append(entry.getValue().size());
            sb.append("\n");
        }
        return sb.toString();
    }

    public synchronized void put(UniqueConnectionIdentifier connectionId, UUID uuid, Object data) {
        List<Object> list;
        Key key = new Key(uuid, connectionId);
        Map<Class, List<Object>> map = this.dataMap.get(key);
        if (map == null) {
            map = new HashMap<Class, List<Object>>();
            this.dataMap.put(key, map);
        }
        if ((list = map.get(data.getClass())) == null) {
            list = new LinkedList<Object>();
            map.put(data.getClass(), list);
        }
        list.add(data);
    }

    public synchronized void remove(UniqueConnectionIdentifier connectionId, UUID uuid, Object data) {
        Key key = new Key(uuid, connectionId);
        Map<Class, List<Object>> map = this.dataMap.get(key);
        if (map != null) {
            Class<?> c = data.getClass();
            List<Object> list = map.get(c);
            if (list == null) {
                Map.Entry<Class, List<Object>> entry;
                Iterator<Map.Entry<Class, List<Object>>> iterator = map.entrySet().iterator();
                while (!(!iterator.hasNext() || c.isAssignableFrom((entry = iterator.next()).getKey()) && entry.getValue().remove(data))) {
                }
            } else {
                list.remove(data);
            }
        }
    }

    public synchronized int removeAll(UniqueConnectionIdentifier connectionId, UUID uuid) {
        Key key = new Key(uuid, connectionId);
        Map<Class, List<Object>> map = this.dataMap.remove(key);
        return map != null ? map.size() : 0;
    }

    public synchronized <T> T get(UniqueConnectionIdentifier connectionId, UUID uuid, Class<T> c) {
        List<T> list = this.getAll(connectionId, uuid, c);
        return list != null && !list.isEmpty() ? (T)list.get(0) : null;
    }

    public synchronized void cleanup(UniqueConnectionIdentifier connectionId) {
        List allocatedResources = this.dataMap.keySet().stream().filter(key -> key.getConnectionId().equals(connectionId)).collect(Collectors.toList());
        for (Key key2 : allocatedResources) {
            this.dataMap.remove(key2);
        }
    }

    public synchronized <T> List<T> getAll(UniqueConnectionIdentifier connectionId, UUID uuid, Class<T> c) {
        Key key = new Key(uuid, connectionId);
        Map<Class, List<Object>> map = this.dataMap.get(key);
        if (map != null) {
            List<Object> list = map.get(c);
            if (list == null) {
                for (Class value : map.keySet()) {
                    if (!c.isAssignableFrom(value)) continue;
                    list = map.get(value);
                }
            }
            return list != null ? list : Collections.EMPTY_LIST;
        }
        return null;
    }

    static class Key {
        private final UUID uuid;
        private final UniqueConnectionIdentifier connectionId;

        public Key(UUID uuid, UniqueConnectionIdentifier connectionId) {
            this.uuid = uuid;
            this.connectionId = connectionId;
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + Objects.hashCode(this.uuid);
            hash = 67 * hash + Objects.hashCode(this.connectionId);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (!Objects.equals(this.uuid, other.uuid)) {
                return false;
            }
            return Objects.equals(this.connectionId, other.connectionId);
        }

        public UniqueConnectionIdentifier getConnectionId() {
            return this.connectionId;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public String toString() {
            return this.connectionId + ": " + this.uuid;
        }
    }
}

