/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.sort;

import de.ubs.jdbcserver.accessor.DataAccessor;
import de.ubs.jdbcserver.command.sql.ParameterValueData;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.util.Pair;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserBaseVisitor;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.jdbccommons.struct.MainframeDataTypes;
import de.ubs.jdbcserver.sort.SortUtils;
import java.nio.charset.Charset;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class SortStatementVisitor
extends SQLParserBaseVisitor<Pair<Boolean, String>> {
    private final Charset charset;
    private final TableDefinition tableDefinition;
    private final DataAccessor[] accessors;
    private final ParameterValueData pvd;
    private boolean isVariableInput = false;

    public SortStatementVisitor(TableDefinition tableDefinition, DataAccessor[] accessors, Charset charset, ParameterValueData pvd) {
        this.tableDefinition = tableDefinition;
        this.accessors = accessors;
        this.charset = charset;
        this.pvd = pvd;
    }

    public void setIsVariableInput(boolean isVariableInput) {
        this.isVariableInput = isVariableInput;
    }

    @Override
    public Pair<Boolean, String> visitColumn(SQLParserParser.ColumnContext ctx) {
        String columnName = ctx.identifier().value;
        int indexOfColumn = this.tableDefinition.indexOfColumn(columnName);
        if (indexOfColumn == -1) {
            throw new RuntimeException(String.format("The column %s is not contained in table %s.%s", columnName, this.tableDefinition.getSchema(), this.tableDefinition.getName()));
        }
        int position = this.accessors[indexOfColumn].getPosition();
        Field field = this.accessors[indexOfColumn].getField();
        return new Pair<Boolean, String>(true, String.format("%d,%d,%s", position + 1 + (this.isVariableInput ? 4 : 0), field.getLength(), SortUtils.getSortTypeSpec(field.getType())));
    }

    @Override
    public Pair<Boolean, String> visitChildren(RuleNode rn) {
        Pair<Boolean, Object> rc = (Pair<Boolean, Object>)super.visitChildren(rn);
        return rc == null ? new Pair<Boolean, Object>(false, null) : rc;
    }

    @Override
    public Pair<Boolean, String> visitParameterMarker(SQLParserParser.ParameterMarkerContext ctx) {
        if (this.pvd == null) {
            throw new RuntimeException("No parameter values provided");
        }
        int parameterMarkerIndex = ctx.no;
        Object data = this.pvd.getLatestValues()[parameterMarkerIndex];
        return new Pair<Boolean, String>(data != null, data != null ? data.toString() : null);
    }

    @Override
    public Pair<Boolean, String> visitConstant(SQLParserParser.ConstantContext ctx) {
        if (ctx.StringLiteral() != null) {
            return new Pair<Boolean, String>(true, StringUtils.strip(ctx.StringLiteral().getText(), "'"));
        }
        if (ctx.number() != null) {
            return new Pair<Boolean, String>(true, ctx.number().getText());
        }
        return new Pair<Boolean, Object>(false, null);
    }

    @Override
    public Pair<Boolean, String> visitOperator(SQLParserParser.OperatorContext ctx) {
        if (null != ctx.OP_EQUALS()) {
            return new Pair<Boolean, String>(true, "EQ");
        }
        if (null != ctx.OP_NOT_EQUALS1() || null != ctx.OP_NOT_EQUALS2()) {
            return new Pair<Boolean, String>(true, "NE");
        }
        if (null != ctx.OP_LESS()) {
            return new Pair<Boolean, String>(true, "LT");
        }
        if (null != ctx.OP_LESS_THAN_OR_EQUALS()) {
            return new Pair<Boolean, String>(true, "LE");
        }
        if (null != ctx.OP_GREATER()) {
            return new Pair<Boolean, String>(true, "GT");
        }
        if (null != ctx.OP_GREATER_THAN_OR_EQUALS()) {
            return new Pair<Boolean, String>(true, "GE");
        }
        return new Pair<Boolean, Object>(false, null);
    }

    @Override
    public Pair<Boolean, String> visitBool(SQLParserParser.BoolContext ctx) {
        Object pair;
        if (ctx.equation() != null) {
            return this.visitEquation(ctx.equation());
        }
        if (ctx.disjunction() != null && (pair = this.visitDisjunction(ctx.disjunction())) != null) {
            return new Pair<Boolean, String>((Boolean)((Pair)pair).first(), "(" + (String)((Pair)pair).second() + ")");
        }
        return new Pair<Boolean, Object>(false, null);
    }

    private Field getLength(SQLParserParser.SumContext ctx) {
        String columnName = ctx.product().atom().column().identifier().value;
        int indexOfColumn = this.tableDefinition.indexOfColumn(columnName);
        if (indexOfColumn != -1) {
            return this.accessors[indexOfColumn].getField();
        }
        return null;
    }

    private boolean isColumn(SQLParserParser.SumContext ctx) {
        return ctx != null && ctx.product() != null && ctx.product().atom() != null && ctx.product().atom().column() != null;
    }

    private boolean isConstant(SQLParserParser.SumContext ctx) {
        if (ctx != null && ctx.product() != null && ctx.product().atom() != null) {
            SQLParserParser.AtomContext atom = ctx.product().atom();
            if (atom.constant() != null) {
                SQLParserParser.ConstantContext x = atom.constant();
                return x.StringLiteral() != null || x.number() != null;
            }
            if (atom.parameterMarker() != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Pair<Boolean, String> visitSum(SQLParserParser.SumContext ctx) {
        if (ctx.sum() != null) {
            return new Pair<Boolean, Object>(false, null);
        }
        return this.visitProduct(ctx.product());
    }

    @Override
    public Pair<Boolean, String> visitProduct(SQLParserParser.ProductContext ctx) {
        if (ctx.product() != null) {
            return new Pair<Boolean, Object>(false, null);
        }
        return (Pair)this.visitAtom(ctx.atom());
    }

    @Override
    public Pair<Boolean, String> visitEquation(SQLParserParser.EquationContext ctx) {
        if (ctx.operator() != null) {
            SQLParserParser.SumContext columnCtx = null;
            SQLParserParser.SumContext constantCtx = null;
            if (this.isColumn(ctx.sum(0))) {
                columnCtx = ctx.sum(0);
            } else if (this.isColumn(ctx.sum(1))) {
                columnCtx = ctx.sum(1);
            }
            if (this.isConstant(ctx.sum(0))) {
                constantCtx = ctx.sum(0);
            } else if (this.isConstant(ctx.sum(1))) {
                constantCtx = ctx.sum(1);
            }
            if (columnCtx == null || constantCtx == null) {
                return new Pair<Boolean, Object>(false, null);
            }
            Object columnValue = this.visitSum(columnCtx);
            Object constantValue = this.visitSum(constantCtx);
            Object op = this.visitOperator(ctx.operator());
            if (((Boolean)((Pair)columnValue).first()).booleanValue() && ((Boolean)((Pair)constantValue).first()).booleanValue() && ((Boolean)((Pair)op).first()).booleanValue()) {
                Field f = this.getLength(columnCtx);
                if (f != null) {
                    MainframeDataTypes type = MainframeDataTypes.valueOf(f.getType());
                    if (type == MainframeDataTypes.STRING) {
                        ((Pair)constantValue).second(StringUtils.rightPad((String)((Pair)constantValue).second(), f.getLength(), " "));
                        ((Pair)constantValue).second(String.format("X'%s'", Hex.encodeHexString(((String)((Pair)constantValue).second()).getBytes(this.charset)).toUpperCase()));
                    } else if (type == MainframeDataTypes.EXTERNAL_DECIMAL || type == MainframeDataTypes.EXTERNAL_FLOAT) {
                        ((Pair)constantValue).second(StringUtils.leftPad((String)((Pair)constantValue).second(), f.getLength(), "0"));
                        ((Pair)constantValue).second(String.format("X'%s'", Hex.encodeHexString(((String)((Pair)constantValue).second()).getBytes(this.charset)).toUpperCase()));
                    }
                }
                return new Pair<Boolean, String>(true, String.format("%s,%s,%s", ((Pair)columnValue).second(), ((Pair)op).second(), ((Pair)constantValue).second()));
            }
        }
        return new Pair<Boolean, Object>(false, null);
    }

    @Override
    public Pair<Boolean, String> visitDisjunction(SQLParserParser.DisjunctionContext ctx) {
        Object conjunction = this.visitConjunction(ctx.conjunction());
        if (null != ctx.disjunction()) {
            Object disjunction = this.visitDisjunction(ctx.disjunction());
            if (((Boolean)((Pair)conjunction).first()).booleanValue() && ((Boolean)((Pair)disjunction).first()).booleanValue()) {
                return new Pair<Boolean, String>(true, String.format("(%s),OR,(%s)", ((Pair)conjunction).second(), ((Pair)disjunction).second()));
            }
            return new Pair<Boolean, Object>(false, null);
        }
        return conjunction;
    }

    @Override
    public Pair<Boolean, String> visitConjunction(SQLParserParser.ConjunctionContext ctx) {
        Object bool = this.visitBool(ctx.bool());
        if (ctx.conjunction() != null) {
            Object conjunction = this.visitConjunction(ctx.conjunction());
            if (((Boolean)((Pair)bool).first()).booleanValue() && ((Boolean)((Pair)conjunction).first()).booleanValue()) {
                return new Pair<Boolean, String>(true, String.format("(%s),AND,(%s)", ((Pair)bool).second(), ((Pair)conjunction).second()));
            }
            if (((Boolean)((Pair)conjunction).first()).booleanValue()) {
                return new Pair<Boolean, String>(false, (String)((Pair)conjunction).second());
            }
            return new Pair<Boolean, String>(false, (String)((Pair)bool).second());
        }
        return bool;
    }
}

