/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Element;

public class XmlUtils {
    public static Element createExceptionElement(Throwable exception) {
        StackTraceElement[] stackTraceElements;
        Element exceptionElement = new Element("exception");
        String className = exception.getClass().getName();
        if (className.equals("com.ibm.jzos.ZFileException")) {
            className = IOException.class.getName();
        }
        exceptionElement.setAttribute("class", className);
        if (exception instanceof SQLException) {
            SQLException sqlexception = (SQLException)exception;
            exceptionElement.setAttribute("sqlcode", String.valueOf(sqlexception.getErrorCode()));
            if (sqlexception.getSQLState() != null) {
                exceptionElement.setAttribute("sqlstate", sqlexception.getSQLState());
            }
        }
        if (exception.getMessage() != null) {
            exceptionElement.setAttribute("message", exception.getMessage());
        }
        Element stackTraceElement = new Element("stackTrace");
        for (StackTraceElement s : stackTraceElements = exception.getStackTrace()) {
            Element sElement = new Element("stackTraceElement");
            if (s.getMethodName() != null) {
                sElement.setAttribute("methodName", s.getClassName() + "." + s.getMethodName());
            }
            if (s.getFileName() != null) {
                sElement.setAttribute("fileName", s.getFileName());
            }
            sElement.setAttribute("lineNumber", Integer.toString(s.getLineNumber()));
            sElement.setAttribute("class", s.getClassName());
            stackTraceElement.addContent(sElement);
        }
        exceptionElement.addContent(stackTraceElement);
        if (exception.getCause() != null) {
            exceptionElement.addContent(XmlUtils.createExceptionElement(exception.getCause()));
        }
        return exceptionElement;
    }

    public static Exception createException(Element root) {
        if (!root.getName().equals("exception")) {
            throw new RuntimeException("Element " + root.getName() + " does not describe an exception.");
        }
        String className = root.getAttributeValue("class");
        String message = root.getAttributeValue("message");
        Element stackTraceElement = root.getChild("stackTrace");
        StackTraceElement[] stackTrace = new StackTraceElement[stackTraceElement.getChildren().size()];
        int idx = 0;
        for (Element element : stackTraceElement.getChildren()) {
            stackTrace[idx] = new StackTraceElement(element.getAttributeValue("class"), element.getAttributeValue("methodName"), element.getAttributeValue("fileName"), Integer.parseInt(element.getAttributeValue("lineNumber")));
            ++idx;
        }
        try {
            String state;
            Exception e = null;
            if (className.equals(SQLWarning.class.getName())) {
                state = root.getAttributeValue("sqlstate");
                int code = Integer.parseInt(root.getAttributeValue("sqlcode"));
                e = new SQLWarning(message, state, code);
            } else if (className.equals(SQLException.class.getName())) {
                state = root.getAttributeValue("sqlstate");
                int code = Integer.parseInt(root.getAttributeValue("sqlcode"));
                e = new SQLException(message, state, code);
            } else {
                try {
                    Constructor<?> constructor = Class.forName(className).getConstructor(String.class);
                    Object exceptionInstance = constructor.newInstance(message);
                    e = (Exception)exceptionInstance;
                }
                catch (NoSuchMethodException nsme) {
                    e = new RuntimeException("Unresolvable contructor for " + className + " with message:\n\t" + message);
                }
            }
            e.setStackTrace(stackTrace);
            if (e instanceof SQLException) {
                SQLException sqlException = e;
                try {
                    throw new SQLException(sqlException.getMessage(), sqlException.getSQLState(), sqlException.getErrorCode(), sqlException);
                }
                catch (SQLException clientCausedByException) {
                    return clientCausedByException;
                }
            }
            return e;
        }
        catch (Exception ex) {
            Logger.getLogger(XmlUtils.class.getName()).log(Level.SEVERE, null, ex);
            return ex;
        }
    }
}

