/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm.struct;

import de.ubs.jdbcserver.jdbccomm.struct.Item;
import de.ubs.jdbcserver.jdbccomm.struct.ItemPath;
import de.ubs.jdbcserver.jdbccomm.struct.Section;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public abstract class AbstractItem
implements Item {
    private String name;
    private int maximumOccurrences = 1;
    private String occurrencesField = null;
    private Item parent;
    private int position = -1;
    private String condition;
    private String redefine;
    private CompiledScript compiledCondition = null;
    private int alignment = -1;
    private ItemPath path = null;

    public AbstractItem(Item parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public String getRedefine() {
        return this.redefine;
    }

    public void setRedefine(String redefine) {
        this.redefine = redefine;
    }

    public boolean isUsedAsRedefine() {
        if (null != this.getParent()) {
            for (AbstractItem i : ((Section)this.getParent()).getItems()) {
                if (!this.getName().equals(i.getRedefine())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String toString() {
        return this.toString(false);
    }

    public ItemPath getFieldPath() {
        if (this.path == null) {
            LinkedList<String> list = new LinkedList<String>();
            Item theParent = this;
            while (theParent.getParent() != null) {
                list.add(theParent.getName());
                theParent = theParent.getParent();
            }
            Collections.reverse(list);
            this.path = new ItemPath(list.toArray(new String[0]));
        }
        return this.path;
    }

    public String toString(boolean absoluteName) {
        return (this.getParent() != null ? ((AbstractItem)this.getParent()).toString(true) + "." : "") + this.getName();
    }

    @Override
    public CompiledScript getCompiledCondition(ScriptEngine engine) {
        if (this.compiledCondition == null) {
            String content = "try{load(\"nashorn:mozilla_compat.js\");\n}catch (e){}\nfunction evaluate() {\n" + this.getCondition() + "\n}\nvar rc = evaluate(); ";
            try {
                this.compiledCondition = ((Compilable)((Object)engine)).compile(content);
            }
            catch (ScriptException ex) {
                Logger.getLogger(AbstractItem.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }
        return this.compiledCondition;
    }

    public void setOccurrencesField(String occurrencesField) {
        this.occurrencesField = occurrencesField;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.name);
        hash = 97 * hash + Objects.hashCode(this.parent);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractItem other = (AbstractItem)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.parent, other.parent);
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public int getAbsolutePosition() {
        int position;
        int parentPosition = 0;
        if (this.getParent() != null) {
            parentPosition = this.getParent().getAbsolutePosition();
        }
        return parentPosition + ((position = this.getPosition()) > 0 ? position : 0);
    }

    @Override
    public Item getParent() {
        return this.parent;
    }

    public boolean containsVaryingLengthElements() {
        return this.getOccurrenceCounterField() != null;
    }

    @Override
    public String getOccurrenceCounterField() {
        return this.occurrencesField;
    }

    @Override
    public int getMaximumOccurrences() {
        return this.maximumOccurrences;
    }

    public void setMaximumOccurrences(int maximumOccurrences) {
        this.maximumOccurrences = maximumOccurrences;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }
}

