/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.index;

import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserBaseVisitor;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import java.util.TreeSet;

class IndexQueryDetectorVisitor
extends SQLParserBaseVisitor<Boolean> {
    private final TableDefinition tableDefinition;
    private final TreeSet<Integer> currentKeyIndexes = new TreeSet();

    public IndexQueryDetectorVisitor(TableDefinition tabeDefinition) {
        this.tableDefinition = tabeDefinition;
    }

    @Override
    public Boolean visitDisjunction(SQLParserParser.DisjunctionContext ctx) {
        if (ctx != null) {
            this.currentKeyIndexes.clear();
            Boolean result = (Boolean)super.visit(ctx.conjunction());
            if (result == null || !result.booleanValue()) {
                return false;
            }
            if (ctx.disjunction() != null) {
                return (Boolean)super.visit(ctx.disjunction());
            }
            if (this.currentKeyIndexes.isEmpty()) {
                return false;
            }
            if (this.currentKeyIndexes.last().intValue() != this.currentKeyIndexes.size()) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitColumn(SQLParserParser.ColumnContext ctx) {
        return true;
    }

    @Override
    public Boolean visitOperator(SQLParserParser.OperatorContext ctx) {
        return null != ctx.OP_EQUALS();
    }

    @Override
    public Boolean visitConstant(SQLParserParser.ConstantContext ctx) {
        if (ctx.StringLiteral() != null) {
            return true;
        }
        if (ctx.number() != null) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitParameterMarker(SQLParserParser.ParameterMarkerContext ctx) {
        return true;
    }

    @Override
    public Boolean visitEquation(SQLParserParser.EquationContext ctx) {
        if (ctx.operator() != null) {
            SQLParserParser.SumContext columnCtx = null;
            SQLParserParser.SumContext constantCtx = null;
            if (this.isColumn(ctx.sum(0))) {
                columnCtx = ctx.sum(0);
            } else if (this.isColumn(ctx.sum(1))) {
                columnCtx = ctx.sum(1);
            }
            if (this.isConstant(ctx.sum(0))) {
                constantCtx = ctx.sum(0);
            } else if (this.isConstant(ctx.sum(1))) {
                constantCtx = ctx.sum(1);
            }
            if (columnCtx == null || constantCtx == null) {
                return false;
            }
            Boolean columnValue = (Boolean)this.visitSum(columnCtx);
            Boolean constantValue = (Boolean)this.visitSum(constantCtx);
            Boolean op = this.visitOperator(ctx.operator());
            if (columnValue.booleanValue() && constantValue.booleanValue() && op.booleanValue()) {
                String columnName = columnCtx.product().atom().column().identifier().value;
                ColumnDefinition columnDefinition = this.tableDefinition.getColumnDefinition(columnName);
                if (columnDefinition == null) {
                    return false;
                }
                if (columnDefinition.getKeySequence() != -1) {
                    this.currentKeyIndexes.add(columnDefinition.getKeySequence());
                    if (constantCtx.product().atom().constant() != null) {
                        return true;
                    }
                    if (constantCtx.product().atom().parameterMarker() != null) {
                        return true;
                    }
                    return false;
                }
                return false;
            }
        }
        return false;
    }

    private boolean isColumn(SQLParserParser.SumContext ctx) {
        return ctx != null && ctx.product() != null && ctx.product().atom() != null && ctx.product().atom().column() != null;
    }

    private boolean isConstant(SQLParserParser.SumContext ctx) {
        if (ctx != null && ctx.product() != null && ctx.product().atom() != null) {
            SQLParserParser.AtomContext atom = ctx.product().atom();
            if (atom.constant() != null) {
                SQLParserParser.ConstantContext x = atom.constant();
                return x.StringLiteral() != null || x.number() != null;
            }
            if (atom.parameterMarker() != null) {
                return true;
            }
        }
        return false;
    }
}

