/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.cursor;

import de.ubs.jdbcserver.command.sql.ParameterValueData;
import de.ubs.jdbcserver.cursor.FileCursor;
import de.ubs.jdbcserver.file.ProcessableFile;
import de.ubs.jdbcserver.index.ByteBuffer;
import de.ubs.jdbcserver.index.IndexUtils;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.util.Pair;
import de.ubs.jdbcserver.jdbccommons.sql.parser.StatementInformation;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Hex;

public class IndexFileCursor
extends FileCursor {
    private final StatementInformation statementInformation;
    private boolean located = false;
    private Iterator<ByteBuffer> currentByteBuffer;
    private byte[] needleBuffer = null;
    private int keyOffset;

    public IndexFileCursor(TablespaceDefinition tablespaceDefinition, TableDefinition tableDefinition, ProcessableFile file, StatementInformation statementInformation) throws IOException, SQLException {
        super(tablespaceDefinition, tableDefinition, file);
        this.statementInformation = statementInformation;
    }

    @Override
    public Object[] next() throws IOException, SQLException {
        if (this.maxRowsToFetch >= 0L && this.rowsReturnedToCaller >= this.maxRowsToFetch) {
            Logger.getLogger(FileCursor.class.getName()).log(Level.FINE, "IndexFileCursor returning no more rows because FETCH FIRST N ROWS ONLY has been reached");
            return null;
        }
        Object[] matchedRecord = null;
        do {
            int readByteCount;
            if (!this.located) {
                if (this.currentByteBuffer == null) {
                    this.initByteBuffer();
                }
                if (!this.currentByteBuffer.hasNext()) {
                    Logger.getLogger(IndexFileCursor.class.getName()).log(Level.FINER, "No more needle, returning");
                    return null;
                }
                this.needleBuffer = this.currentByteBuffer.next().getFinalBuffer();
                if (this.needleBuffer == null) {
                    Logger.getLogger(IndexFileCursor.class.getName()).log(Level.FINER, "Needle is null.");
                    continue;
                }
                if (Logger.getLogger(IndexFileCursor.class.getName()).isLoggable(Level.FINER)) {
                    Logger.getLogger(IndexFileCursor.class.getName()).log(Level.FINER, "Locate to key {0}", Hex.encodeHexString(this.needleBuffer));
                }
                if (!this.file.locate(this.needleBuffer)) {
                    Logger.getLogger(IndexFileCursor.class.getName()).log(Level.FINER, "Key not found");
                    continue;
                }
                this.located = true;
            }
            if ((readByteCount = this.file.readRecord(this.workingArea)) == -1) {
                Logger.getLogger(IndexFileCursor.class.getName()).log(Level.FINER, "readRecord returned -1 ==> EOF encountered");
                return null;
            }
            if (!this.patternMatches(this.workingArea, this.needleBuffer)) {
                this.located = false;
                Logger.getLogger(IndexFileCursor.class.getName()).log(Level.FINER, "Found end of key matching, do relocate");
                continue;
            }
            matchedRecord = this.matchesFilter(this.splitter.split(0L, Arrays.copyOfRange(this.workingArea, 0, readByteCount)));
        } while (matchedRecord == null);
        ++this.rowsReturnedToCaller;
        return matchedRecord;
    }

    private boolean patternMatches(byte[] workingArea, byte[] needle) {
        if (Logger.getLogger(IndexFileCursor.class.getName()).isLoggable(Level.FINER)) {
            Logger.getLogger(IndexFileCursor.class.getName()).log(Level.FINER, "Compare needle to {0}", Hex.encodeHexString(Arrays.copyOfRange(workingArea, this.keyOffset, this.keyOffset + needle.length)));
        }
        for (int i = 0; i < needle.length; ++i) {
            if (workingArea[i + this.keyOffset] == needle[i]) continue;
            return false;
        }
        return true;
    }

    protected void initByteBuffer() {
        ParameterValueData parameterMarkerContents = this.getConditionEvaluator().getVisitor().getParameterMarkerContents();
        Logger.getLogger(IndexFileCursor.class.getName()).log(Level.FINE, "Init paramaterized statements");
        IndexUtils indexUtils = new IndexUtils();
        Pair<Boolean, List<ByteBuffer>> indexPrefix = indexUtils.buildIndexPrefix(this.layout, this.statementInformation, parameterMarkerContents);
        this.keyOffset = indexUtils.getKeyOffset();
        this.currentByteBuffer = indexPrefix.second().iterator();
    }

    @Override
    public void reset() throws IOException, SQLException {
        this.located = false;
        this.currentByteBuffer = null;
        super.reset();
    }
}

