/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.command.sql;

import de.ubs.jdbcserver.evaluation.ExpressionEvaluator;
import de.ubs.jdbcserver.jdbccomm.util.XmlUtils;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;

public abstract class PreparedContext {
    protected final List<Integer> rcs = new LinkedList<Integer>();
    protected final List<SQLException> exceptions = new LinkedList<SQLException>();
    protected final ExpressionEvaluator<Object> visitor;

    public PreparedContext(ExpressionEvaluator<Object> visitor) {
        this.visitor = visitor;
    }

    public ExpressionEvaluator<Object> getVisitor() {
        return this.visitor;
    }

    public void resetStatus() {
        this.exceptions.clear();
        this.rcs.clear();
    }

    public Element buildReplayTag(String name) {
        Element e = new Element(name).setText(StringUtils.join(this.rcs, ","));
        if (!this.exceptions.isEmpty()) {
            for (SQLException exception : this.exceptions) {
                e.addContent(XmlUtils.createExceptionElement(exception));
            }
        }
        return e;
    }

    public void addException(SQLException e) {
        this.rcs.add(-3);
        this.exceptions.add(e);
    }

    public List<Integer> getRcs() {
        return this.rcs;
    }
}

