/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.sort;

import de.ubs.jdbcserver.accessor.DataAccessor;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccommons.sql.parser.ColumnInformation;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.jdbccommons.sql.parser.StatementInformation;
import de.ubs.jdbcserver.jdbccommons.struct.MainframeDataTypes;
import de.ubs.jdbcserver.sort.ExpressionOptimizer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SortUtils {
    private static final Map<MainframeDataTypes, String> sortTypeMap = new HashMap<MainframeDataTypes, String>();

    public static String getSortTypeSpec(String type) {
        MainframeDataTypes t = MainframeDataTypes.valueOf(type);
        return sortTypeMap.get((Object)t);
    }

    private static List<SortFieldSpec> buildSortSpec(TableDefinition table, DataAccessor[] accessors, List<ColumnSpec> columnsSpecs) throws SQLException {
        LinkedList<SortFieldSpec> columns = new LinkedList<SortFieldSpec>();
        for (ColumnSpec spec : columnsSpecs) {
            int columnIndex = table.indexOfColumn(spec.columnName);
            if (columnIndex == -1) {
                throw new SQLException(String.format("Column %s in ORDER BY does not identify a column of the result table.", spec.columnName), "42707", -208);
            }
            DataAccessor accessor = accessors[columnIndex];
            Field field = accessor.getField();
            if (field.getLength() > 4092) {
                throw new SQLException("The column " + spec.columnName + " is too long for sort", "54005", -136);
            }
            columns.add(new SortFieldSpec(accessor.getPosition() + 1, field.getLength(), MainframeDataTypes.valueOf(field.getType()), spec.order));
        }
        return columns;
    }

    public static List<String> buildSortCommand(TableDefinition td, DataAccessor[] accessors, StatementInformation statement, int lrecl) throws SQLException, IOException {
        SQLParserParser.OrderByClauseContext orderByClause;
        boolean distinctSpecified;
        LinkedList<String> commands = new LinkedList<String>();
        LinkedList<SortFieldSpec> sortColumns = new LinkedList<SortFieldSpec>();
        boolean bl = distinctSpecified = statement.getStatementInformation().selectStatement().DISTINCT() != null;
        if (distinctSpecified) {
            commands.add(String.format("INREC OVERLAY=(%d:C'00000001')", lrecl + 1));
        }
        if ((orderByClause = statement.getStatementInformation().selectStatement().orderByClause()) != null) {
            sortColumns.addAll(SortUtils.buildSortSpec(td, accessors, ColumnSpec.createListFormOrderingColumns(orderByClause.orderBySpec())));
        }
        if (distinctSpecified) {
            List<ColumnSpec> selectedColumns = ColumnSpec.createList(statement.getReferencedColumnList());
            for (SortFieldSpec sortFieldSpec : SortUtils.buildSortSpec(td, accessors, selectedColumns)) {
                if (sortColumns.contains(sortFieldSpec)) continue;
                sortColumns.add(sortFieldSpec);
            }
        }
        if (!sortColumns.isEmpty()) {
            commands.add(SortUtils.buildSortExpression(sortColumns));
        } else {
            commands.add("SORT FIELDS=COPY");
        }
        if (distinctSpecified) {
            commands.add(String.format("SUM FIELDS=(%d,8,ZD)", lrecl + 1));
        }
        return commands;
    }

    private static String buildSortExpression(List<SortFieldSpec> columns) throws RuntimeException {
        StringBuilder sb = new StringBuilder();
        sb.append("SORT FIELDS=(");
        boolean isFirst = true;
        for (SortFieldSpec spec : columns) {
            String typeName;
            if (!isFirst) {
                sb.append(",");
            }
            if ((typeName = sortTypeMap.get((Object)spec.type)) == null) {
                throw new RuntimeException("Type " + (Object)((Object)spec.type) + " is not supported for DFSORT");
            }
            sb.append(String.format("%d,%d,%s,%s", spec.position, spec.length, typeName, spec.order == Order.ASC ? "A" : "D"));
            isFirst = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public static List<String> buildIncludeCommand(ExpressionOptimizer opt) {
        LinkedList<String> commands = new LinkedList<String>();
        if (opt.getSortFilterExpression() != null && opt.getSortFilterExpression().length() < 16384) {
            commands.add(String.format("INCLUDE COND=(%s)", opt.getSortFilterExpression()));
        }
        return commands;
    }

    static {
        sortTypeMap.put(MainframeDataTypes.STRING, "CH");
        sortTypeMap.put(MainframeDataTypes.EXTERNAL_DECIMAL, "CH");
        sortTypeMap.put(MainframeDataTypes.EXTERNAL_FLOAT, "CH");
        sortTypeMap.put(MainframeDataTypes.BINARY, "BI");
        sortTypeMap.put(MainframeDataTypes.DOUBLE, "FL");
        sortTypeMap.put(MainframeDataTypes.FLOAT, "FL");
        sortTypeMap.put(MainframeDataTypes.SHORT, "FI");
        sortTypeMap.put(MainframeDataTypes.INTEGER, "FI");
        sortTypeMap.put(MainframeDataTypes.LONG, "FI");
        sortTypeMap.put(MainframeDataTypes.UNSIGNED_SHORT, "BI");
        sortTypeMap.put(MainframeDataTypes.UNSIGNED_INTEGER, "BI");
        sortTypeMap.put(MainframeDataTypes.UNSIGNED_LONG, "BI");
        sortTypeMap.put(MainframeDataTypes.PACKED_DECIMAL, "PD");
        sortTypeMap.put(MainframeDataTypes.UNSIGNED_PACKED_DECIMAL, "PD");
    }

    static class ColumnSpec {
        public Order order;
        public String columnName;

        public ColumnSpec(Order order, String columnName) {
            this.order = order;
            this.columnName = columnName;
        }

        public static List<ColumnSpec> createListFormOrderingColumns(List<SQLParserParser.OrderBySpecContext> orderableColumns) {
            LinkedList<ColumnSpec> list = new LinkedList<ColumnSpec>();
            for (SQLParserParser.OrderBySpecContext spec : orderableColumns) {
                list.add(new ColumnSpec(spec.DESC() != null ? Order.DESC : Order.ASC, spec.identifier().value));
            }
            return list;
        }

        public static List<ColumnSpec> createList(List<ColumnInformation> columns) {
            LinkedList<ColumnSpec> list = new LinkedList<ColumnSpec>();
            for (ColumnInformation column : columns) {
                list.add(new ColumnSpec(Order.ASC, column.getName()));
            }
            return list;
        }
    }

    public static class SortFieldSpec {
        public int position;
        public int length;
        public Order order;
        MainframeDataTypes type;

        public SortFieldSpec(int position, int length, MainframeDataTypes type, Order order) {
            this.position = position;
            this.length = length;
            this.type = type;
            this.order = order;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + this.position;
            hash = 79 * hash + this.length;
            hash = 79 * hash + Objects.hashCode((Object)this.type);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SortFieldSpec other = (SortFieldSpec)obj;
            if (this.position != other.position) {
                return false;
            }
            if (this.length != other.length) {
                return false;
            }
            return this.type == other.type;
        }
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

