/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccommons.struct;

import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablePermission;
import de.ubs.jdbcserver.jdbccomm.struct.UserPermission;
import de.ubs.jdbcserver.jdbccomm.util.Pair;
import de.ubs.jdbcserver.jdbccommons.struct.CatalogManager;
import de.ubs.jdbcserver.jdbccommons.struct.DatabaseEngine;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;

public class PermissionManager {
    private static PermissionManager instance;
    private final Map<Pair<String, TableDefinition>, TablePermission> tablePermissions = new HashMap<Pair<String, TableDefinition>, TablePermission>();
    private final Map<String, UserPermission> userPermissions = new HashMap<String, UserPermission>();
    private String superUser = System.getProperty("user.name").toUpperCase();
    private String superUserPassword = DigestUtils.sha256Hex("default");

    public static synchronized PermissionManager getDefault() {
        if (instance == null) {
            instance = new PermissionManager();
            try {
                PermissionManager.getDefault().load();
            }
            catch (SQLException ex) {
                Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(8);
            }
        }
        return instance;
    }

    public void load() throws SQLException {
        DatabaseEngine databaseEngine = CatalogManager.getDatabaseEngine();
        try {
            databaseEngine.loadPermissions(this);
        }
        catch (IOException ex) {
            Logger.getLogger(PermissionManager.class.getName()).log(Level.SEVERE, "Failed to load permissions: {0}", ex.getMessage());
            System.exit(8);
        }
    }

    private void store() throws SQLException {
        DatabaseEngine databaseEngine = CatalogManager.getDatabaseEngine();
        try {
            databaseEngine.writePermissions(this);
            Logger.getLogger(PermissionManager.class.getName()).log(Level.FINE, "Updated permissions");
        }
        catch (IOException ex) {
            throw new SQLException(ex.getMessage(), "57011", -904);
        }
    }

    public void checkPermission(TableDefinition td, String user, TablePermission.Action action) throws SQLException {
        TablePermission tp;
        if ((user = user.toUpperCase()).equalsIgnoreCase(this.superUser)) {
            return;
        }
        boolean allowed = false;
        UserPermission up = this.getOrNull(user);
        if (up != null && up.isSysadm()) {
            allowed = true;
        }
        if (!allowed && (tp = this.getOrNull(td, user)) != null) {
            switch (action) {
                case DELETE: {
                    allowed = tp.isDelete();
                    break;
                }
                case INSERT: {
                    allowed = tp.isInsert();
                    break;
                }
                case UPDATE: {
                    allowed = tp.isUpdate();
                    break;
                }
                case SELECT: {
                    allowed = tp.isSelect();
                    break;
                }
                case GRANT: {
                    allowed = user.equalsIgnoreCase(td.getCreator());
                    break;
                }
                case REVOKE: {
                    allowed = user.equalsIgnoreCase(tp.getGrantor());
                }
            }
        }
        if (!allowed) {
            throw new SQLException(String.format("%s does not have the privilege to perform operation %s on table %s.%s", user, action.toString(), td.getSchema(), td.getName()), "42501", -551);
        }
    }

    public void checkPermission(String user, UserPermission.Action action) throws SQLException {
        if ((user = user.toUpperCase()).equalsIgnoreCase(this.superUser)) {
            return;
        }
        boolean allowed = false;
        UserPermission up = this.getOrNull(user);
        if (up != null) {
            if (up.isSysadm()) {
                allowed = true;
            } else {
                switch (action) {
                    case CREATE_TABLE: {
                        allowed = up.isCreateTable();
                        break;
                    }
                    case CREATE_TABLESPACE: {
                        allowed = up.isCreateTablespace();
                        break;
                    }
                    case DROP_TABLE: {
                        allowed = up.isDropTable();
                        break;
                    }
                    case DROP_TABLESPACE: {
                        allowed = up.isDropTablespace();
                        break;
                    }
                }
            }
        }
        if (!allowed) {
            throw new SQLException(String.format("%s does not have the privilege to perform operation %s", user, action.toString()), "42502", -552);
        }
    }

    public String getSuperUser() {
        return this.superUser;
    }

    public void setSuperUser(String superUser) {
        this.superUser = superUser;
    }

    public String getSuperUserPassword() {
        return this.superUserPassword;
    }

    public void setSuperUserPassword(String superUserPassword) {
        this.superUserPassword = DigestUtils.sha256Hex(superUserPassword);
    }

    public Map<Pair<String, TableDefinition>, TablePermission> getTablePermissions() {
        return this.tablePermissions;
    }

    public void removePermissionsFor(TableDefinition td) throws SQLException {
        Set<Pair<String, TableDefinition>> keys = this.tablePermissions.keySet();
        for (Pair<String, TableDefinition> key : keys) {
            if (!key.second().equals(td)) continue;
            this.tablePermissions.remove(key);
        }
        this.store();
    }

    public Map<String, UserPermission> getUserPermissions() {
        return this.userPermissions;
    }

    private UserPermission getOrNull(String grantee) {
        return this.userPermissions.get(grantee);
    }

    private UserPermission getOrThrow(String grantee) throws SQLWarning {
        UserPermission permission = this.getOrNull(grantee);
        if (permission == null) {
            throw new SQLWarning("A privilege was not revoked", "01006", 569);
        }
        return permission;
    }

    private UserPermission getOrCreate(String grantor, String grantee) {
        UserPermission permission = this.userPermissions.get(grantee);
        if (permission == null) {
            permission = new UserPermission(grantee, grantor);
            this.userPermissions.put(grantee, permission);
        }
        return permission;
    }

    public void grantDropTable(String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.GRANT);
        this.getOrCreate(grantor, grantee).grantDropTable();
        this.store();
    }

    public void grantDropTablespace(String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.GRANT);
        this.getOrCreate(grantor, grantee).grantDropTablespace();
        this.store();
    }

    public void revokeDropTable(String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.REVOKE);
        this.getOrThrow(grantee).revokeDropTable();
        this.store();
    }

    public void revokeDropTablespace(String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.REVOKE);
        this.getOrThrow(grantee).revokeDropTablespace();
        this.store();
    }

    public void grantCreateTable(String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.GRANT);
        this.getOrCreate(grantor, grantee).grantCreateTable();
        this.store();
    }

    public void grantCreateTablespace(String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.GRANT);
        this.getOrCreate(grantor, grantee).grantCreateTablespace();
        this.store();
    }

    public void grantSysadm(String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.GRANT);
        this.getOrCreate(grantor, grantee).grantSysadm();
        this.store();
    }

    public void revokeCreateTable(String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.REVOKE);
        this.getOrThrow(grantee).revokeCreateTable();
        this.store();
    }

    public void revokeSysadm(String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.REVOKE);
        this.getOrThrow(grantee).revokeSysadm();
        this.store();
    }

    public void revokeCreateTablespace(String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.REVOKE);
        this.getOrThrow(grantee).revokeCreateTablespace();
        this.store();
    }

    private TablePermission getOrNull(TableDefinition table, String grantee) {
        Pair<String, TableDefinition> granteeTablePair = new Pair<String, TableDefinition>(grantee, table);
        return this.tablePermissions.get(granteeTablePair);
    }

    private TablePermission getOrThrow(TableDefinition table, String grantee) throws SQLWarning {
        TablePermission permission = this.getOrNull(table, grantee);
        if (permission == null) {
            throw new SQLWarning("A privilege was not revoked", "01006", 569);
        }
        return permission;
    }

    private TablePermission getOrCreate(TableDefinition table, String grantor, String grantee) {
        Pair<String, TableDefinition> granteeTablePair = new Pair<String, TableDefinition>(grantee, table);
        TablePermission permission = this.tablePermissions.get(granteeTablePair);
        if (permission == null) {
            permission = new TablePermission(grantee, grantor, table.getSchema(), table.getName());
            this.tablePermissions.put(granteeTablePair, permission);
        }
        return permission;
    }

    public void grantInsert(TableDefinition table, String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.GRANT);
        this.getOrCreate(table, grantor, grantee).grantInsert();
        this.store();
    }

    public void revokeInsert(TableDefinition table, String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.REVOKE);
        this.getOrThrow(table, grantee).revokeInsert();
        this.store();
    }

    public void grantUpdate(TableDefinition table, String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.GRANT);
        this.getOrCreate(table, grantor, grantee).grantUpdate();
        this.store();
    }

    public void revokeUpdate(TableDefinition table, String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.REVOKE);
        this.getOrThrow(table, grantee).revokeUpdate();
        this.store();
    }

    public void grantDelete(TableDefinition table, String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.GRANT);
        this.getOrCreate(table, grantor, grantee).grantDelete();
        this.store();
    }

    public void revokeDelete(TableDefinition table, String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.REVOKE);
        this.getOrThrow(table, grantee).revokeDelete();
        this.store();
    }

    public void grantSelect(TableDefinition table, String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.GRANT);
        this.getOrCreate(table, grantor, grantee).grantSelect();
        this.store();
    }

    public void revokeSelect(TableDefinition table, String grantor, String grantee) throws SQLException {
        this.checkPermission(grantor, UserPermission.Action.REVOKE);
        this.getOrThrow(table, grantee).revokeSelect();
        this.store();
    }
}

