/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccommons.sql.parser;

import de.ubs.jdbcserver.jdbccommons.sql.parser.ANTLRNoCaseFileStream;
import de.ubs.jdbcserver.jdbccommons.sql.parser.ColumnInformation;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserBaseVisitor;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserLexer;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.jdbccommons.sql.parser.StatementInformation;
import java.io.IOException;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;

public class ParserUtils {
    private SQLException parserError = null;

    public static Set<String> getReferencedColumns(SQLParserParser.DisjunctionContext ctx) {
        final HashSet<String> output = new HashSet<String>();
        new SQLParserBaseVisitor<Object>(){

            @Override
            public Object visitColumn(SQLParserParser.ColumnContext ctx) {
                if (ctx.identifier() != null) {
                    output.add(ctx.identifier().value);
                }
                return super.visitColumn(ctx);
            }
        }.visitDisjunction(ctx);
        return output;
    }

    public static String getDirectColumnName(SQLParserParser.ColRefContext colref) {
        try {
            return colref.sum().product().atom().column().identifier().value;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public StatementInformation parseSelect(String sql) throws IOException, SQLException {
        return this.parseSQL(sql);
    }

    public SQLParserParser.DisjunctionContext parseDisjuncation(String sql) throws IOException, SQLException {
        this.parserError = null;
        ANTLRNoCaseFileStream in = new ANTLRNoCaseFileStream(sql);
        SQLParserLexer lexer = new SQLParserLexer(in);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        SQLParserParser parser = new SQLParserParser(tokens);
        parser.addErrorListener(new ErrorHandler());
        SQLParserParser.DisjunctionContext disjunction = parser.disjunction();
        if (null != this.parserError) {
            Logger.getLogger(ParserUtils.class.getName()).log(Level.FINE, this.parserError.getMessage(), this.parserError);
            throw this.parserError;
        }
        return disjunction;
    }

    public StatementInformation parseSQL(String sql) throws IOException, SQLException {
        this.parserError = null;
        ANTLRNoCaseFileStream in = new ANTLRNoCaseFileStream(sql);
        SQLParserLexer lexer = new SQLParserLexer(in);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        SQLParserParser parser = new SQLParserParser(tokens);
        parser.addErrorListener(new ErrorHandler());
        SQLParserParser.StatementContext tree = parser.statement();
        if (null != this.parserError) {
            Logger.getLogger(ParserUtils.class.getName()).log(Level.FINE, this.parserError.getMessage(), this.parserError);
            throw this.parserError;
        }
        StatementInformation info = new StatementInformation();
        if (tree.selectStatement() != null && null == tree.selectStatement().STAR()) {
            for (SQLParserParser.ColRefContext colRef : tree.selectStatement().colRef()) {
                ColumnInformation ci = new ColumnInformation();
                String directColumnName = ParserUtils.getDirectColumnName(colRef);
                if (directColumnName != null) {
                    ci.setName(directColumnName);
                } else {
                    ci.setName(String.format("COL%03d", info.getReferencedColumnList().size() + 1));
                }
                if (colRef.label() != null) {
                    ci.setLabel(colRef.label().identifier().value);
                }
                info.getReferencedColumnList().add(ci);
            }
        }
        info.setStatementInformation(tree);
        if (tree.selectStatement() != null) {
            SQLParserParser.FromClauseContext fromClause = tree.selectStatement().fromClause();
            if (fromClause.schema() != null) {
                info.setTableSchema(fromClause.schema().identifier().value);
            } else {
                info.setTableSchema(System.getProperty("user.name"));
            }
            if (fromClause.name().label() != null) {
                info.setLabel(fromClause.name().label().identifier().value);
            }
            info.setTableName(fromClause.name().identifier().value);
        } else if (tree.alterTable() != null) {
            info.setTableSchema(tree.alterTable().schema().identifier().value);
            info.setTableName(tree.alterTable().name().identifier().value);
        } else if (tree.insertStatement() != null) {
            if (tree.insertStatement().schema() != null) {
                info.setTableSchema(tree.insertStatement().schema().identifier().value);
            }
            info.setTableName(tree.insertStatement().name().identifier().value);
        } else if (tree.deleteStatement() != null) {
            if (tree.deleteStatement().schema() != null) {
                info.setTableSchema(tree.deleteStatement().schema().identifier().value);
            }
            info.setTableName(tree.deleteStatement().name().identifier().value);
        } else if (tree.updateStatement() != null) {
            if (tree.updateStatement().schema() != null) {
                info.setTableSchema(tree.updateStatement().schema().identifier().value);
            }
            info.setTableName(tree.updateStatement().name().identifier().value);
        }
        return info;
    }

    class ErrorHandler
    implements ANTLRErrorListener {
        ErrorHandler() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> rcgnzr, Object o, int lineNo, int i1, String err, RecognitionException re) {
            ParserUtils.this.parserError = new SQLException("Invalid syntax: " + err + " at line " + lineNo + " position " + i1, "42601", -104);
        }

        @Override
        public void reportAmbiguity(Parser parser, DFA dfa, int i, int i1, boolean bln, BitSet bitset, ATNConfigSet atncs) {
            ParserUtils.this.parserError = new SQLException("Invalid syntax: reportAmbiguity()", "42601", -104);
        }

        @Override
        public void reportAttemptingFullContext(Parser parser, DFA dfa, int i, int i1, BitSet bitset, ATNConfigSet atncs) {
            ParserUtils.this.parserError = new SQLException("Invalid syntax: reportAttemptingFullContext()", "42601", -104);
        }

        @Override
        public void reportContextSensitivity(Parser parser, DFA dfa, int i, int i1, int i2, ATNConfigSet atncs) {
            ParserUtils.this.parserError = new SQLException("Invalid syntax: reportContextSensitivity()", "42601", -104);
        }
    }
}

