/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.cursor;

import de.ubs.jdbcserver.cursor.AbstractCursor;
import de.ubs.jdbcserver.cursor.FileCursor;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VirtualCursor
extends AbstractCursor {
    private final List<Object[]> bufferedData = new LinkedList<Object[]>();
    private int currentPosition = 0;

    public VirtualCursor(TableDefinition tableDefinition) {
        super(tableDefinition);
    }

    @Override
    public void reset() throws IOException, SQLException {
        this.currentPosition = 0;
    }

    public void addRecord(Object[] rec) {
        this.bufferedData.add(rec);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getName() {
        return this.getTableDefinition().getName();
    }

    @Override
    public void update(Object[] data) throws IOException {
        throw new UnsupportedOperationException("Update of " + this.getName() + " is not supported yet.");
    }

    @Override
    public boolean delete() throws IOException {
        throw new UnsupportedOperationException("Delete of " + this.getName() + " is not supported yet.");
    }

    @Override
    public void insert(Object[] data) throws IOException {
        throw new UnsupportedOperationException("Insert into " + this.getName() + " is not supported yet.");
    }

    @Override
    public Object[] next() throws IOException, SQLException {
        if (this.maxRowsToFetch >= 0L && this.rowsReturnedToCaller >= this.maxRowsToFetch) {
            Logger.getLogger(FileCursor.class.getName()).log(Level.FINE, "VirtualCursor returning no more rows because FETCH FIRST N ROWS ONLY has been reached");
            return null;
        }
        Object[] matchedData = null;
        do {
            if (this.currentPosition >= this.bufferedData.size()) {
                return null;
            }
            ++this.currentPosition;
        } while ((matchedData = this.matchesFilter(this.bufferedData.get(this.currentPosition - 1))) == null);
        ++this.rowsReturnedToCaller;
        return matchedData;
    }

    @Override
    public void close() throws IOException {
    }
}

