/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.builder;

import de.ubs.jdbcserver.accessor.AccessorFactory;
import de.ubs.jdbcserver.accessor.DataAccessor;
import de.ubs.jdbcserver.builder.RecordBuilder;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import java.sql.SQLException;

public class SimpleRecordBuilder
implements RecordBuilder {
    private final Field[] fields;
    private final DataAccessor[] accessors;
    private boolean materializeRecords = false;

    public SimpleRecordBuilder(TablespaceLayout layout, TableDefinition tableDefinition) {
        this.accessors = AccessorFactory.create(layout, tableDefinition);
        this.fields = new Field[this.accessors.length];
        for (int i = 0; i < this.accessors.length; ++i) {
            this.fields[i] = layout.getField(tableDefinition.getColumns().get(i).getFieldPath());
        }
    }

    @Override
    public void setFullRecordMaterialization(boolean b) {
        this.materializeRecords = b;
    }

    @Override
    public int build(byte[] output, Object[] dataArray) throws SQLException {
        if (dataArray.length != this.accessors.length) {
            throw new SQLException(String.format("Provided data array contains %d elements, expected %d", dataArray.length, this.accessors.length));
        }
        int offset = 0;
        int correctionOffset = 0;
        for (int i = 0; i < dataArray.length; ++i) {
            int fieldLength = this.fields[i].getLength();
            if (dataArray[i] != null) {
                this.accessors[i].put(dataArray[i], output, correctionOffset);
                if (this.accessors[i].getLastLength() != -1) {
                    correctionOffset -= this.accessors[i].getField().getLength() - this.accessors[i].getLastLength();
                    offset += this.accessors[i].getLastLength();
                    continue;
                }
                offset += fieldLength;
                continue;
            }
            if (this.materializeRecords) {
                for (int j = 0; j < fieldLength; ++j) {
                    output[offset + j] = -1;
                }
                continue;
            }
            correctionOffset -= fieldLength;
        }
        return offset;
    }
}

