/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.builder;

import de.ubs.jdbcserver.builder.RecordBuilder;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.FastDateFormat;

public class CSVRecordBuilder
implements RecordBuilder {
    private final TableDefinition tableDefinition;
    private final Charset encoding;
    private final char decimalDelimiter;
    private final char stringDelimiter;
    private final char columnDelimiter;
    private final String stringForTrue;
    private final String stringForFalse;
    private final Map<Integer, FastDateFormat> timestampFormatMap = new HashMap<Integer, FastDateFormat>();
    private final TablespaceDefinition.CsvQuoteMode csvQuoteMode;
    private final String nonStringQuotes;
    private boolean fullRecordMaterialization = false;
    private Pattern stringDelimiterPattern;
    private String escapedStringDelimiterReplacement;

    public CSVRecordBuilder(TablespaceDefinition tablespaceDefinition, TableDefinition tableDefinition) {
        this.tableDefinition = tableDefinition;
        this.encoding = tablespaceDefinition.getLayout().getDefaultStringEncoding();
        this.stringDelimiter = tablespaceDefinition.getCSVStringDelimiter();
        this.decimalDelimiter = tablespaceDefinition.getCSVDecimalDelimiter();
        this.columnDelimiter = tablespaceDefinition.getCSVColumnDelimiter();
        this.stringForTrue = tablespaceDefinition.getCSVBooleanRepresentation(true);
        this.stringForFalse = tablespaceDefinition.getCSVBooleanRepresentation(false);
        this.csvQuoteMode = tablespaceDefinition.getCSVQuoteMode();
        this.nonStringQuotes = this.csvQuoteMode == TablespaceDefinition.CsvQuoteMode.ALL ? Character.toString(this.stringDelimiter) : "";
        List<ColumnDefinition> columnList = tableDefinition.getColumns();
        for (int i = 0; i < columnList.size(); ++i) {
            switch (columnList.get(i).getType()) {
                case 91: 
                case 92: 
                case 93: {
                    this.timestampFormatMap.put(i, FastDateFormat.getInstance(columnList.get(i).getTimestampPattern()));
                }
            }
        }
        this.preparePatterns();
    }

    CSVRecordBuilder(char columnDelimiter, char stringDelimiter, char decimalDelimiter) {
        this.tableDefinition = null;
        this.encoding = null;
        this.stringDelimiter = stringDelimiter;
        this.decimalDelimiter = decimalDelimiter;
        this.columnDelimiter = columnDelimiter;
        this.stringForTrue = null;
        this.stringForFalse = null;
        this.csvQuoteMode = TablespaceDefinition.CsvQuoteMode.STRINGS;
        this.nonStringQuotes = "";
        this.preparePatterns();
    }

    public static String escape(String s, TablespaceDefinition.CsvQuoteMode csvQuoteMode, char stringDelimiter, Pattern stringDelimiterPattern, String escapedStringDelimiterReplacement) {
        switch (csvQuoteMode) {
            case NONE: {
                return s;
            }
            case ALL: 
            case STRINGS: {
                return stringDelimiter + stringDelimiterPattern.matcher(s).replaceAll(escapedStringDelimiterReplacement) + stringDelimiter;
            }
            case MINIMAL: {
                if (s.indexOf(stringDelimiter) == -1) {
                    return s;
                }
                return stringDelimiter + stringDelimiterPattern.matcher(s).replaceAll(escapedStringDelimiterReplacement) + stringDelimiter;
            }
        }
        throw new RuntimeException("Invalid quote mode " + csvQuoteMode.toString());
    }

    private final void preparePatterns() {
        String strDel = Character.toString(this.stringDelimiter);
        this.stringDelimiterPattern = Pattern.compile(strDel, 16);
        this.escapedStringDelimiterReplacement = Matcher.quoteReplacement(strDel + strDel);
    }

    @Override
    public void setFullRecordMaterialization(boolean b) {
        this.fullRecordMaterialization = b;
    }

    public String escape(String s) {
        return CSVRecordBuilder.escape(s, this.csvQuoteMode, this.stringDelimiter, this.stringDelimiterPattern, this.escapedStringDelimiterReplacement);
    }

    @Override
    public int build(byte[] output, Object[] dataArray) throws SQLException {
        if (dataArray.length != this.tableDefinition.getColumns().size()) {
            throw new RuntimeException(String.format("Data array has %d element(s), but table has %d column(s)", dataArray.length, this.tableDefinition.getColumns().size()));
        }
        StringBuilder sb = new StringBuilder();
        block9: for (int i = 0; i < this.tableDefinition.getColumns().size(); ++i) {
            Object val;
            ColumnDefinition colDef = this.tableDefinition.getColumns().get(i);
            if (i > 0) {
                sb.append(this.columnDelimiter);
            }
            if ((val = dataArray[i]) == null) continue;
            switch (colDef.getType()) {
                case -5: 
                case 4: 
                case 5: {
                    sb.append(this.nonStringQuotes).append((BigDecimal)val).append(this.nonStringQuotes);
                    continue block9;
                }
                case 1: 
                case 12: {
                    sb.append(this.escape((String)val));
                    continue block9;
                }
                case 3: 
                case 6: 
                case 8: {
                    String tmp = ((BigDecimal)val).toPlainString();
                    sb.append(this.nonStringQuotes);
                    sb.append(this.decimalDelimiter == '.' ? tmp : tmp.replace('.', this.decimalDelimiter));
                    sb.append(this.nonStringQuotes);
                    continue block9;
                }
                case 16: {
                    sb.append(this.nonStringQuotes);
                    if (val instanceof Boolean) {
                        sb.append((Boolean)val != false ? this.stringForTrue : this.stringForFalse);
                    } else {
                        sb.append(val.toString());
                    }
                    sb.append(this.nonStringQuotes);
                    continue block9;
                }
                case 91: 
                case 92: 
                case 93: {
                    Date theDate;
                    FastDateFormat timestampFormat = this.timestampFormatMap.get(i);
                    if (timestampFormat == null) {
                        throw new SQLException("Date / Time / Timestamp format for column " + colDef.getName() + " was not specified");
                    }
                    if (val instanceof Date) {
                        theDate = (Date)val;
                    } else {
                        try {
                            theDate = timestampFormat.parse(val.toString());
                        }
                        catch (ParseException ex) {
                            throw new SQLException("Malformed Date / Time / Timestamp: " + val.toString() + " for format " + timestampFormat, ex);
                        }
                    }
                    sb.append(this.nonStringQuotes);
                    sb.append(timestampFormat.format(theDate));
                    sb.append(this.nonStringQuotes);
                    continue block9;
                }
                default: {
                    throw new SQLException("CSVRecordBuilder does not support type " + colDef.getType() + " yet");
                }
            }
        }
        String sbString = sb.toString();
        byte[] bytes = sbString.getBytes(this.encoding);
        System.arraycopy(bytes, 0, output, 0, bytes.length);
        return bytes.length;
    }
}

