/*
 */

grammar PL1pict;

pictSpec:   charPict | numPict | floatPict ;

charPict:   (charSeq nineSeq? | nineSeq charSeq)+ ;
            
//charSeq:    (repeatSpec? CHARTYPE+ insertChar*) ;

charSeq:    (repeatSpec CHARTYPE insertChar*) |
            (CHARTYPE+ insertChar*) ;
            
nineSeq:    (repeatSpec NINETYPE insertChar*) |
            (NINETYPE+ insertChar*);
        
numSeq:     (repeatSpec? NUMTYPE+ insertChar*) ;

numPict:    (decimalSpec currencySpec?) | 
            ((numSeq | nineSeq)+ decimalSpec? currencySpec?)  | 
            (currencySpec? (numSeq | nineSeq)+ decimalSpec?)
       ;

decimalSpec: (insertChar* IMPLDEC (numSeq | nineSeq)+) |
             (IMPLDEC insertChar* (numSeq | nineSeq)+)
           ;

floatPict:  ((numSeq | nineSeq)+ decimalSpec? EXP (numSeq | nineSeq)+) |
            (decimalSpec EXP (numSeq | nineSeq)+) 
         ;

repeatSpec: PAREN_L DIGIT+ PAREN_R ;

insertChar: (APOS | COMMA | DOT | SLASH | 'B') ;// [',./B]

currencySpec: (DOLLAR+ | LT .+? GT+) ;

CHARTYPE:   ('A' | 'X') ;

NINETYPE:   ('9') ;

NUMTYPE:    ('S' | 'Z' | '*' | '+' | '-' ) ;

IMPLDEC:    'V' ;

EXP:        ('E' | 'K') ;

/* Tokens */

AMPERSAND:  ('&') ;
APOS:       ('\'') ;
ARROW_R:    ('->') ;
COLON:      (':') ;
COMMA:      (',') ;
DOLLAR:     ('$') ;
EQUAL:      ('=') ;
EXCLAM:     ('!') ;
NULL:       ('\u0000') -> skip ;
PAREN_L:    ('(') ;
PAREN_R:    (')') ;
PERCENT:    ('%') ;
DOT:        ('.') ;
POUND:      ('\u00A3') ;
QMARK:      ('?') ;
QUOTE:      ('"') ;
SEMICOLON:  (';') ;
SLASH:      ('/') ;
SPACE:      (' ') -> skip ;
UNDERSCORE: ('_') ;

// --- OPERATORS ---

GT:         ('>') ;
LT:         ('<') ;
CARET:      ('^') ;
DIGIT:      ('0'..'9') ;

WHITESPACE: (' '|'\r'|'\n'|'\t'|'0x1A') -> skip ;
