
/*
 */

grammar PL1decl;

declStmtList: ((declStmt | defnStmt) SEMICOLON)+ ;

defnStmt    : DEFINE (aliasDefn | ordinalDefn | structDefn) ;

aliasDefn   : ALIAS ID dimAttr? attrList ;

ordinalDefn : ORDINAL ID PAREN_L ordValueList PAREN_R 
              precision? (SIGNED | UNSIGNED)?
            ;

ordValueList : ID (VALUE PAREN_L INT PAREN_R)? 
               COMMA (ID (VALUE PAREN_L INT PAREN_R)?)*
             ;

structDefn  : STRUCTURE declList ; 

declStmt    : DECLARE declList ;

declList    : declItem (COMMA declItem)* ;

declItem    : INT? (ID | ASTER | PAREN_L declList PAREN_R)
              dimAttr? attrList? ;

dimAttr     : DIMACROSS? PAREN_L boundSpec (COMMA boundSpec)* PAREN_R ;

//boundSpec   : (intExpr (COLON intExpr)? | ASTER) ;
boundSpec   : (lowerBound COLON)? upperBound ;

lowerBound  : (expr referSpec? | ASTER) ;

upperBound  : expr referSpec? ;

referSpec   : REFER PAREN_L ID PAREN_R ;

attrList    : (dataAttr | nonDataAttr | scopeAttr | likeAttr |
               DIMENSION dimAttr)+ ;

dataAttr    : (numericAttr | stringAttr | pictAttr | areaAttr | labelAttr |
               offsetAttr | defAttr | basedAttr | storageAttr | initAttr |
               litDataAttr) 
              ;

litDataAttr : (POINTER | TASK | EVENT | CELL | UNION | PACKED |
               UNALIGNED | ALIGNED | SECONDARY | NORMAL | ABNORMAL) 
              ;

litNumAttr  : (REAL | COMPLEX | DECIMAL | BINARY | FLOAT | FIXED |
               UNSIGNED | SIGNED) 
              ;

numericAttr : (litNumAttr+  precision litNumAttr*) ;

precision   : PAREN_L INT (COMMA INT)? PAREN_R ;

stringAttr  : (BIT | CHARACTER | WIDECHAR | GRAPHIC) 
              lengthSpec referSpec?
              (NONVARYING | VARYING | VARYING4 | VARYINGZ)?
              ;

lengthSpec  : PAREN_L (expr | ASTER) PAREN_R ;

pictAttr    : PICTURE (CHARSTRING | QCHARSTRING) ;

//pictSpec    : APOS (pictString | pictString 'F' PAREN_L INT PAREN_R |
//               pictString 'F' PAREN_L addOp INT PAREN_R ) APOS
//            ;
//pictSpec    : APOS .+? APOS | QUOTE .+? QUOTE;

//pictString  : (pictChar | PAREN_L INT PAREN_R pictChar+)+ ;

//pictChar    : (ID | ASTER | MINUS | DOT | PLUS | SLASH | DOLLAR) ;

areaAttr    : (AREA | AREA PAREN_L (expr | ASTER) PAREN_R) ;

labelAttr   : LABEL ID (COMMA ID)* ;

offsetAttr  : (OFFSET | OFFSET PAREN_L reference PAREN_R) ;

defAttr     : (DEFINED basicRef | POSITION PAREN_L INT PAREN_R) ;

basedAttr   : (BASED | BASED PAREN_L reference PAREN_R) ;

storageAttr : (AUTOMATIC | STATIC | CONTROLLED) ;

initAttr    : INITIAL (initCall | initItemList) ;

initCall    : CALL ID argList? ;

argList     : PAREN_L expr (COMMA expr)* PAREN_R ;

initItemList: PAREN_L initItem (COMMA initItem)* PAREN_R ;

initItem    : (initIteration | initConst | string | ASTER) ;

//reference   : (basicRef | reference ARROW_R basicRef) ;
reference   : UNDEFINED ;

//basicRef    : (DOT unqualRef)+;
basicRef    : UNDEFINED ;

//unqualRef   : (ID | ID PAREN_L (expr | ASTER) (expr | ASTER)* PAREN_R) ;

initIteration: PAREN_L expr PAREN_R (initConst | initItemList) ;

initConst   : (number | imgNumber);

//nonDataAttr : entryAttr | fileAttr | genericAttr | BUILTIN ;
nonDataAttr : UNDEFINED ;
scopeAttr:    UNDEFINED ;
likeAttr:     UNDEFINED ;

// --- EXPRESSIONS ---

addOp:      PLUS | MINUS ;
multOp:     ASTER | SLASH ;
powerOp:    ASTER ASTER ;

expr:       (numExpr | reference | constant) ;

fcnExpr:    ID argList ;
            
numExpr:    multExpr (addOp multExpr)* ;

multExpr:   powerExpr (multOp powerExpr)* ;

powerExpr:  atomicExpr (powerOp atomicExpr)* ;

atomicExpr: (ID | number | addOp? PAREN_L numExpr PAREN_R) ;

number:     addOp? INT (DOT INT)? ('E' addOp? INT)? ;

imgNumber:  number 'I' ;

// --- CONSTANTS ---

constant:   (string | fixedConst | replString | sterling) ;

//fixedConst: (INT | INT DOT | DOT INT | INT DOT INT) ;
fixedConst: UNDEFINED ;

sterling:   INT DOT INT DOT fixedConst POUND;

string:     (CHARSTRING | BITSTRING) ;

replString: PAREN_L INT PAREN_R string ;

//bitString:  APOS ('0'|'1')* APOS 'B' ;

// charString: APOS CHAR* APOS ;


// ---------------
// --- TOKENS  ---
// ---------------

// The following is a special token used for elements which are part of
// the PL/1 grammar, but not (yet) implemented for the parser.

UNDEFINED:  ('UNDEFINED') ;

// --- Strings ---

BITSTRING: '\'' ('0' | '1')+ '\'B';
CHARSTRING: '\'' (~'\'')* '\'';
QCHARSTRING: '"' (~'"')* '"';

// --- RESERVED WORDS ---

ABNORMAL:   ('ABNORMAL'|'ABNL') ;
ALIAS:      ('ALIIAS') ;
ALIGNED:    ('ALIGNED') ;
AREA:       ('AREA') ;
AUTOMATIC:  ('AUTOMATIC'|'AUTO') ;
BASED:      ('BASED') ;
BINARY:     ('BINARY'|'BIN') ;
BIT:        ('BIT') ;
BUILTIN:    ('BUILTIN') ;
CALL:       ('CALL') ;
CELL:       ('CELL') ;
CHARACTER:  ('CHARACTER'|'CHAR') ;
COMPLEX:    ('COMPLEX'|'CPLX') ;
CONTROLLED: ('CONTROLLED'|'CTL') ;
DECIMAL:    ('DECIMAL'|'DEC') ;
DECLARE:    ('DECLARE'|'DCL') ;
DEFINE:     ('DEFINE') ;
DEFINED:    ('DEFINED'|'DEF') ;
DIMACROSS:   ('DIMACROSS') ;
DIMENSION:  ('DIMENSION'|'DIM') ;
ENTRY:      ('ENTRY') ;
EVENT:      ('EVENT') ;
FIXED:      ('FIXED') ;
FLOAT:      ('FLOAT') ;
GRAPHIC:    ('GRAPHIC'|'G') ;
INITIAL:    ('INITIAL') ;
IRREDUCIBLE: ('IRREDUCIBLE'|'IRRED') ;
LABEL:      ('LABEL') ;
NONVARYING: ('NONVARING'|'NONVAR') ;
NORMAL:     ('NORMAL') ;
NOT:        ('\u00AC') ;
OFFSET:     ('OFFSET') ;
ORDINAL:    ('ORDINAL') ;
PACKED:     ('PACKED') ;
PICTURE:    ('PICTURE' | 'PIC') ;
POINTER:    ('POINTER'|'PTR') ;
POSITION:   ('POSITION'|'POS') ;
PRECISION:  ('PRECISION'|'PREC') ;
REAL:       ('REAL') ;
REDUCIBLE:  ('REDUCIBLE'|'RED') ;
REFER:      ('REFER') ;
RETURNS:    ('RETURNS') ;
SECONDARY:  ('SECONDARY') ;
SETS:       ('SETS') ;
SIGNED:     ('SIGNED') ;
STATIC:     ('STATIC') ;
STRUCTURE:  ('STRUCTURE'|'STRUCT') ;
TASK:       ('TASK') ;
UNALIGNED:  ('UNALIGNED') ;
UNION:      ('UNION') ;
UNSIGNED:   ('UNSIGNED') ;
USES:       ('USES') ;
VALUE:      ('VALUE') ;
VARYING:    ('VARYING'|'VAR') ;
VARYING4:   ('VARYING4'|'VAR4') ;
VARYINGZ:   ('VARYINGZ'|'VARZ') ;
WIDECHAR:   ('WIDECHAR'|'WCHAR') ;
        
// --- SYMBOLS ---

AMPERSAND:  ('&') ;
APOS:       ('\'') ;
ARROW_R:    ('->') ;
ASTER:      ('*') ;
COLON:      (':') ;
COMMA:      (',') ;
DOLLAR:     ('$') ;
EQUAL:      ('=') ;
EXCLAM:     ('!') ;
NULL:       ('\u0000') -> skip ;
PAREN_L:    ('(') ;
PAREN_R:    (')') ;
PERCENT:    ('%') ;
DOT:        ('.') ;
POUND:      ('\u00A3') ;
QMARK:      ('?') ;
QUOTE:      ('"') ;
SEMICOLON:  (';') ;
SLASH:      ('/') ;
SPACE:      (' ') -> skip ;
UNDERSCORE: ('_') ;

// --- OPERATORS ---

GT:         ('>') ;
LT:         ('<') ;
MINUS:      ('-') ;
PLUS:       ('+') ;
CARET:      ('^') ;

// --- NUMBERS, CHARS, WHITESPACE, ETC  ---

ID:         ('a'..'z'|'A'..'Z'|UNDERSCORE) 
            ('a'..'z'|'A'..'Z'|'0'..'9'|UNDERSCORE)* 
            ;
INT:        ('0'..'9')+ ;
NEWLINE:    ('\r'|'\n')  -> skip ;
//WHITESPACE: (' '|'\r'|'\n'|'\t') {skip();} ;
WHITESPACE: (' '|'\r'|'\n'|'\t') -> skip ;
//ML_COMMENT: '/*' (options {greedy=false;} : .)* '*/' {skip();} ;
//ML_COMMENT: '/*' (options {greedy=false;} : .)* '*/' {$channel=HIDDEN;} ;
ML_COMMENT: ( '/*' .*? '*/' ) -> skip ;
