/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cb2xml.def;

import net.sf.cb2xml.def.NumericDefinition;

public class BasicNumericDefinition
implements NumericDefinition {
    public static final int[] DEFAULT_SYNC = new int[]{1, 1, 4, 8};
    public static final int[] MAINFRAME_SIZES = new int[]{2, 4, 8};
    public static final int[] MAINFRAME_SYNC = new int[]{2, 2, 4, 4};
    private static final int[] MAINFRAME_DIGITS = new int[]{4, 9, 18};
    public static final int[] FUJITSU_SIZES = MAINFRAME_SIZES;
    public static final int[] FUJITSU_SYNC = new int[]{2, 2, 4, 4};
    public static final int[] OPEN_COBOL_SIZES = new int[]{1, 2, 4, 8};
    public static final int[] OPEN_COBOL_SYNC = new int[]{2, 2, 4, 4};
    public static final int[] BS2000_SIZES = MAINFRAME_SIZES;
    public static final int[] BS2000_SYNC = new int[]{2, 2, 4, 8};
    public static final int[] OPEN_COBOL_MVS_SIZES = MAINFRAME_SIZES;
    public static final int[] OPEN_COBOL_MVS_SYNC = BS2000_SYNC;
    public static final int[] MICROFOCUS_SIZES = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    public static final int[] MICROFOCUS_SIZES_SYNC = new int[]{1, 1, 1, 1};
    public static final int[] MAX_COMP_SIZE = new int[]{2, 4, 6, 9, 11, 14, 16, 18};
    public static final int[] MAX_POSITIVE_COMP_SIZE = new int[]{2, 4, 7, 9, 12, 14, 16, 19};
    private int[] compSizesUsed = MAINFRAME_SIZES;
    private int[] digitsAvailable = MAINFRAME_DIGITS;
    private int[] positiveDigitsAvailable = this.digitsAvailable;
    private int[] syncSizes = DEFAULT_SYNC;
    private int floatSync = 4;
    private int doubleSync = 8;
    private String name;

    public BasicNumericDefinition(String string, int[] nArray, int[] nArray2, boolean bl, int n, int n2) {
        int[] nArray3 = new int[nArray.length];
        this.compSizesUsed = new int[nArray.length];
        this.name = string;
        this.syncSizes = DEFAULT_SYNC;
        if (nArray2 != null) {
            this.syncSizes = nArray2;
        }
        this.digitsAvailable = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.compSizesUsed[i] = nArray[i];
            int n3 = Math.min(MAX_COMP_SIZE.length, nArray[i]) - 1;
            this.digitsAvailable[i] = MAX_COMP_SIZE[n3];
            nArray3[i] = MAX_POSITIVE_COMP_SIZE[n3];
        }
        this.positiveDigitsAvailable = this.digitsAvailable;
        if (bl) {
            this.positiveDigitsAvailable = nArray3;
        }
        this.floatSync = n;
        this.doubleSync = n2;
    }

    public String getName() {
        return this.name;
    }

    public int getBinarySize(String string, int n, boolean bl, boolean bl2) {
        int n2 = n;
        if ("computational-1".equalsIgnoreCase(string)) {
            n2 = 4;
        } else if ("computational-2".equalsIgnoreCase(string)) {
            n2 = 8;
        } else if ("computational-3".equalsIgnoreCase(string) || "packed-decimal".equalsIgnoreCase(string) || "computational-6".equalsIgnoreCase(string)) {
            n2 = n / 2 + 1;
        } else if (this.isBinary(string)) {
            n2 = this.compSizesUsed[this.compSizesUsed.length - 1];
            for (int i = 0; i < this.digitsAvailable.length - 1; ++i) {
                if (this.digitsAvailable[i] < n && (!bl || this.positiveDigitsAvailable[i] < n)) continue;
                n2 = this.compSizesUsed[Math.max(0, i)];
                break;
            }
        }
        return n2;
    }

    public int getSyncAt(String string, int n) {
        int n2 = 1;
        if (this.isBinary(string)) {
            switch (n) {
                case 1: {
                    n2 = this.syncSizes[0];
                    break;
                }
                case 2: {
                    n2 = this.syncSizes[1];
                    break;
                }
                case 3: 
                case 4: {
                    n2 = this.syncSizes[2];
                    break;
                }
                default: {
                    n2 = this.syncSizes[3];
                    break;
                }
            }
        } else if ("computational-1".equals(string)) {
            n2 = this.floatSync;
        } else if ("computational-2".equals(string)) {
            n2 = this.doubleSync;
        }
        return n2;
    }

    public int chkStorageLength(int n, String string) {
        int n2 = n;
        if (n == 0) {
            if ("computational-1".equalsIgnoreCase(string)) {
                n2 = 10;
            } else if ("computational-2".equalsIgnoreCase(string)) {
                n2 = 18;
            }
        }
        return n2;
    }

    private boolean isBinary(String string) {
        return "binary".equalsIgnoreCase(string) || "computational".equalsIgnoreCase(string) || "computational-4".equalsIgnoreCase(string) || "computational-5".equalsIgnoreCase(string) || "computational-6".equalsIgnoreCase(string);
    }
}

