/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.splitter;

import de.ubs.jdbcserver.evaluation.ExpressionEvaluator;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccommons.sql.parser.ParserUtils;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Set;

public class SimpleSplitterFilter {
    private int[] fieldIndexes = null;
    private ExpressionEvaluator<Boolean> visitor;
    private String[] columns;

    public SimpleSplitterFilter(TablespaceLayout layout, TableDefinition tableDefinition) throws SQLException, IOException {
        String when = tableDefinition.getWhenCondition();
        ParserUtils utils = new ParserUtils();
        SQLParserParser.DisjunctionContext context = utils.parseDisjuncation(when);
        this.visitor = new ExpressionEvaluator(tableDefinition, null, context);
        Set<String> referencedColumns = ParserUtils.getReferencedColumns(context);
        this.fieldIndexes = new int[referencedColumns.size()];
        this.columns = new String[referencedColumns.size()];
        int idx = 0;
        for (String column : referencedColumns) {
            this.fieldIndexes[idx] = tableDefinition.indexOfColumn(column);
            this.columns[idx] = column;
            ++idx;
        }
    }

    public int[] getFieldIndexes() {
        return this.fieldIndexes;
    }

    public boolean evaluate(Object[] inputFields) throws SQLException {
        for (int i = 0; i < this.columns.length; ++i) {
            this.visitor.setValue(this.columns[i], (Comparable)inputFields[i]);
        }
        Boolean b = this.visitor.evaluate();
        return b == null ? true : b;
    }

    public String[] getColumns() {
        return this.columns;
    }
}

