/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.splitter;

import de.ubs.jdbcserver.accessor.AccessorFactory;
import de.ubs.jdbcserver.accessor.DataAccessor;
import de.ubs.jdbcserver.evaluation.ExpressionEvaluator;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccommons.sql.parser.ParserUtils;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.splitter.RecordSplitter;
import de.ubs.jdbcserver.splitter.SimpleSplitterFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Hex;

public class SimpleRecordSplitter
implements RecordSplitter {
    private final DataAccessor[] dataAccessors;
    private final SimpleSplitterFilter filter;
    private final Object[] tempDataForFilter;
    private final ExpressionEvaluator<Boolean>[] evaluators;
    private final String[] occurrenceFields;

    public SimpleRecordSplitter(TablespaceLayout layout, TableDefinition tableDefinition) throws SQLException, IOException {
        this.dataAccessors = AccessorFactory.create(layout, tableDefinition);
        if (tableDefinition.getWhenCondition() != null && !tableDefinition.getWhenCondition().trim().isEmpty()) {
            this.filter = new SimpleSplitterFilter(layout, tableDefinition);
            this.tempDataForFilter = new Object[this.filter.getFieldIndexes().length];
        } else {
            this.filter = null;
            this.tempDataForFilter = null;
        }
        int columnCount = tableDefinition.getColumns().size();
        this.evaluators = new ExpressionEvaluator[columnCount];
        this.occurrenceFields = new String[columnCount];
        ParserUtils util = new ParserUtils();
        for (int i = 0; i < columnCount; ++i) {
            ColumnDefinition columnDefinition = tableDefinition.getColumns().get(i);
            if (columnDefinition.getExistenceExpression() == null) continue;
            SQLParserParser.DisjunctionContext tree = util.parseDisjuncation(columnDefinition.getExistenceExpression());
            Set<String> referencedColumns = ParserUtils.getReferencedColumns(tree);
            this.evaluators[i] = new ExpressionEvaluator(tableDefinition, null, tree);
            for (String column : referencedColumns) {
                int indexOfColumn = tableDefinition.indexOfColumn(column);
                if (indexOfColumn == -1) {
                    throw new RuntimeException("The column " + column + " is not part of the table. ");
                }
                this.occurrenceFields[indexOfColumn] = column;
            }
        }
    }

    public DataAccessor[] getDataAccessors() {
        return this.dataAccessors;
    }

    @Override
    public Object[] split(long recordNo, byte[] record) throws SQLException {
        if (this.filter != null) {
            for (int i = 0; i < this.filter.getFieldIndexes().length; ++i) {
                this.tempDataForFilter[i] = this.dataAccessors[this.filter.getFieldIndexes()[i]].get(record);
            }
            if (!this.filter.evaluate(this.tempDataForFilter)) {
                return null;
            }
        }
        int correctionOffset = 0;
        int readBytes = 0;
        Object[] output = new Object[this.dataAccessors.length];
        for (int i = 0; i < this.dataAccessors.length && this.dataAccessors[i].getPosition() + correctionOffset < record.length; ++i) {
            boolean fieldPresent = true;
            if (this.evaluators[i] != null) {
                Boolean evaluateResult = this.evaluators[i].evaluate();
                boolean bl = fieldPresent = evaluateResult == null ? true : evaluateResult;
                if (!fieldPresent) {
                    correctionOffset -= this.dataAccessors[i].getField().getLength();
                }
            }
            if (fieldPresent) {
                try {
                    output[i] = record.length <= this.dataAccessors[i].getPosition() + correctionOffset ? null : this.dataAccessors[i].get(record, correctionOffset);
                    if (this.dataAccessors[i].getLastLength() != -1) {
                        correctionOffset -= this.dataAccessors[i].getField().getLength() - this.dataAccessors[i].getLastLength();
                    }
                    readBytes = this.dataAccessors[i].getPosition() + this.dataAccessors[i].getField().getLength() + correctionOffset;
                }
                catch (Exception e) {
                    try {
                        String data = Hex.encodeHexString(Arrays.copyOfRange(record, this.dataAccessors[i].getPosition(), this.dataAccessors[i].getPosition() + this.dataAccessors[i].getField().getLength()));
                        String type = this.dataAccessors[i].getClass().getName() + " for " + this.dataAccessors[i].getField().getType();
                        String allDataAccessorsTillThis = "";
                        for (int j = 0; j < i; ++j) {
                            allDataAccessorsTillThis = allDataAccessorsTillThis + this.dataAccessors[j].getField().getFieldPath().toString() + "(" + this.dataAccessors[j].getField().getLength() + "), ";
                        }
                        String msg = String.format("Failed to process record %d at position: %d correctionOffset: %d field: %s index: %d: Data: %s Type: %s\nAll data accesors till this field: %s", recordNo, this.dataAccessors[i].getPosition(), correctionOffset, this.dataAccessors[i].getField().getFieldPath().toString(), i, data, type, allDataAccessorsTillThis);
                        Logger.getLogger(SimpleRecordSplitter.class.getName()).log(Level.SEVERE, msg);
                        throw new SQLException(msg, e);
                    }
                    catch (RuntimeException rex) {
                        Logger.getLogger(SimpleRecordSplitter.class.getName()).log(Level.SEVERE, "Error building message:", rex);
                        throw rex;
                    }
                }
            }
            if (this.occurrenceFields[i] == null) continue;
            for (ExpressionEvaluator<Boolean> evaluator : this.evaluators) {
                if (evaluator == null) continue;
                evaluator.setValue(this.occurrenceFields[i], (Comparable)output[i]);
            }
        }
        return output;
    }
}

