/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.splitter;

import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.util.Pair;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import de.ubs.jdbcserver.splitter.RecordSplitter;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.FastDateFormat;

public class CSVRecordSplitter
implements RecordSplitter {
    private static final Pattern ESCAPED_APOSTROPHES = Pattern.compile("''", 16);
    private final Date ZERO_DATE = Date.valueOf("0001-01-01");
    private final Time ZERO_TIME = Time.valueOf("00:00:00");
    private final Timestamp ZERO_TIMESTAMP = Timestamp.valueOf("0001-01-01 00:00:00");
    private final TableDefinition tableDefinition;
    private final Charset encoding;
    private final char decimalDelimiter;
    private final char stringDelimiter;
    private final char columnDelimiter;
    private final String stringForTrue;
    private final String stringForFalse;
    private Map<Integer, FastDateFormat> timestampFormatMap = new HashMap<Integer, FastDateFormat>();
    private Pattern escapedStringDelimiterPattern;
    private String stringDelimiterReplacement;

    public CSVRecordSplitter(TablespaceDefinition tablespaceDefinition, TableDefinition tableDefinition) {
        this.tableDefinition = tableDefinition;
        this.encoding = tablespaceDefinition.getLayout().getDefaultStringEncoding();
        this.stringDelimiter = tablespaceDefinition.getCSVStringDelimiter();
        this.decimalDelimiter = tablespaceDefinition.getCSVDecimalDelimiter();
        this.columnDelimiter = tablespaceDefinition.getCSVColumnDelimiter();
        this.stringForTrue = tablespaceDefinition.getCSVBooleanRepresentation(true);
        this.stringForFalse = tablespaceDefinition.getCSVBooleanRepresentation(false);
        List<ColumnDefinition> columnList = tableDefinition.getColumns();
        for (int i = 0; i < columnList.size(); ++i) {
            switch (columnList.get(i).getType()) {
                case 91: 
                case 92: 
                case 93: {
                    this.timestampFormatMap.put(i, FastDateFormat.getInstance(columnList.get(i).getTimestampPattern()));
                }
            }
        }
        this.preparePatterns();
    }

    CSVRecordSplitter(char columnDelimiter, char stringDelimiter, char decimalDelimiter) {
        this.tableDefinition = null;
        this.encoding = null;
        this.stringDelimiter = stringDelimiter;
        this.decimalDelimiter = decimalDelimiter;
        this.columnDelimiter = columnDelimiter;
        this.stringForTrue = null;
        this.stringForFalse = null;
        this.preparePatterns();
    }

    public static String unescapeSqlStringLiteral(String s) {
        if (s == null) {
            return null;
        }
        String stringDelimiterReplacement = Matcher.quoteReplacement("'");
        if (s.length() >= 2 && s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            String r = s.substring(1, s.length() - 1);
            return ESCAPED_APOSTROPHES.matcher(r).replaceAll(stringDelimiterReplacement);
        }
        return s;
    }

    private final void preparePatterns() {
        String strDel = Character.toString(this.stringDelimiter);
        this.escapedStringDelimiterPattern = Pattern.compile(strDel + strDel, 16);
        this.stringDelimiterReplacement = Matcher.quoteReplacement(strDel);
    }

    public Pair<String, Boolean> unescape(String s) {
        if (s == null) {
            return new Pair<Object, Boolean>(null, false);
        }
        if (s.length() >= 2 && s.charAt(0) == this.stringDelimiter && s.charAt(s.length() - 1) == this.stringDelimiter) {
            String r = s.substring(1, s.length() - 1);
            return new Pair<String, Boolean>(this.escapedStringDelimiterPattern.matcher(r).replaceAll(this.stringDelimiterReplacement), true);
        }
        return new Pair<String, Boolean>(s, false);
    }

    String[] splitCsvRecord(String s) {
        LinkedList<Integer> colDelPositions = new LinkedList<Integer>();
        boolean inQuotes = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == this.columnDelimiter) {
                if (inQuotes) continue;
                colDelPositions.add(i);
                continue;
            }
            if (c != this.stringDelimiter) continue;
            if (inQuotes) {
                if (s.length() > i + 1 && s.charAt(i + 1) == this.stringDelimiter) {
                    ++i;
                    continue;
                }
                inQuotes = false;
                continue;
            }
            inQuotes = true;
        }
        String[] ret = new String[colDelPositions.size() + 1];
        int startPos = 0;
        int i = 0;
        Iterator iterator = colDelPositions.iterator();
        while (iterator.hasNext()) {
            int endPos = (Integer)iterator.next();
            ret[i] = s.substring(startPos, endPos);
            startPos = endPos + 1;
            ++i;
        }
        ret[i] = s.substring(startPos);
        return ret;
    }

    private java.util.Date stringToDate(int colIdx, String colName, String val) throws SQLException {
        FastDateFormat timestampFormat = this.timestampFormatMap.get(colIdx);
        if (timestampFormat == null) {
            throw new SQLException("Date / Time / Timestamp format for column " + colName + " was not specified");
        }
        try {
            return timestampFormat.parse(val);
        }
        catch (ParseException ex) {
            throw new SQLException(String.format("Could not convert \"%s\" to date / time / timestamp value", val), "22007", -180);
        }
    }

    @Override
    public Object[] split(long recordNo, byte[] input) throws SQLException {
        String rowString = new String(input, this.encoding);
        String[] fields = this.splitCsvRecord(rowString);
        if (fields.length != this.tableDefinition.getColumns().size()) {
            throw new SQLException(String.format("Expected %d columns in row, but found %d. The row is: \"%s\"", this.tableDefinition.getColumns().size(), fields.length, rowString));
        }
        Object[] ret = new Object[fields.length];
        int i = 0;
        for (ColumnDefinition colDef : this.tableDefinition.getColumns()) {
            block25: {
                String val;
                int colType;
                block24: {
                    colType = colDef.getType();
                    boolean nullable = colDef.isNullable();
                    Pair<String, Boolean> pair = this.unescape(fields[i]);
                    val = pair.first();
                    boolean wasInDelimiters = pair.second();
                    if (!val.isEmpty()) break block24;
                    switch (colType) {
                        case -5: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 8: {
                            ret[i] = nullable ? null : BigDecimal.ZERO;
                            break block25;
                        }
                        case 1: 
                        case 12: {
                            ret[i] = wasInDelimiters ? "" : (nullable ? null : "");
                            break block25;
                        }
                        case 16: {
                            ret[i] = nullable ? null : Boolean.valueOf(false);
                            break block25;
                        }
                        case 91: {
                            ret[i] = nullable ? null : this.ZERO_DATE;
                            break block25;
                        }
                        case 92: {
                            ret[i] = nullable ? null : this.ZERO_TIME;
                            break block25;
                        }
                        case 93: {
                            ret[i] = nullable ? null : this.ZERO_TIMESTAMP;
                            break block25;
                        }
                        default: {
                            throw new SQLException("CSVRecordSplitter does not support type " + colDef.getTypeName() + " yet");
                        }
                    }
                }
                switch (colType) {
                    case -5: 
                    case 4: 
                    case 5: {
                        try {
                            ret[i] = new BigDecimal(val);
                            break;
                        }
                        catch (NumberFormatException ex) {
                            throw new SQLException(String.format("Could not convert \"%s\" to numeric value", val), "42604", -103);
                        }
                    }
                    case 1: 
                    case 12: {
                        ret[i] = val;
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 8: {
                        try {
                            if (this.decimalDelimiter != '.') {
                                ret[i] = new BigDecimal(val.replace(this.decimalDelimiter, '.'));
                                break;
                            }
                            ret[i] = new BigDecimal(val);
                            break;
                        }
                        catch (NumberFormatException ex) {
                            throw new SQLException(String.format("Could not convert \"%s\" to numeric value", val), "42604", -103);
                        }
                    }
                    case 16: {
                        ret[i] = this.stringForTrue.equalsIgnoreCase(val);
                        break;
                    }
                    case 91: {
                        ret[i] = new Date(this.stringToDate(i, colDef.getName(), val).getTime());
                        break;
                    }
                    case 92: {
                        ret[i] = new Time(this.stringToDate(i, colDef.getName(), val).getTime());
                        break;
                    }
                    case 93: {
                        ret[i] = new Timestamp(this.stringToDate(i, colDef.getName(), val).getTime());
                        break;
                    }
                    default: {
                        throw new SQLException("CSVRecordSplitter does not support type " + colDef.getTypeName() + " yet");
                    }
                }
            }
            ++i;
        }
        return ret;
    }
}

