/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.sort;

import de.ubs.jdbcserver.jdbccomm.util.Pair;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserBaseVisitor;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.sort.SortStatementVisitor;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;

public class TreeOptimizer
extends SQLParserBaseVisitor<String> {
    private final SortStatementVisitor filter;

    public TreeOptimizer(SortStatementVisitor filterVisitor) {
        this.filter = filterVisitor;
    }

    @Override
    public String visitDisjunction(SQLParserParser.DisjunctionContext ctx) {
        if (ctx.disjunction() == null) {
            Object rc = this.filter.visitConjunction(ctx.conjunction());
            if (((Boolean)((Pair)rc).first()).booleanValue()) {
                return null;
            }
            if (((Pair)rc).second() != null) {
                return this.visitConjunction(ctx.conjunction());
            }
        } else {
            Object result = this.filter.visitDisjunction(ctx);
            if (((Boolean)((Pair)result).first()).booleanValue()) {
                return null;
            }
            return this.getOriginalText(ctx);
        }
        String conjuction = this.visitConjunction(ctx.conjunction());
        if (conjuction == null) {
            conjuction = this.getOriginalText(ctx.conjunction());
        }
        if (null != ctx.disjunction()) {
            String disjunction = this.visitDisjunction(ctx.disjunction());
            if (disjunction == null) {
                disjunction = this.getOriginalText(ctx.disjunction());
            }
            return String.format("%s OR %s", conjuction, disjunction);
        }
        return conjuction;
    }

    private String getOriginalText(ParserRuleContext ctx) {
        int a = ctx.start.getStartIndex();
        int b = ctx.stop.getStopIndex();
        Interval interval = new Interval(a, b);
        CharStream inputStream = ctx.getStart().getInputStream();
        return inputStream.getText(interval);
    }

    @Override
    public String visitConjunction(SQLParserParser.ConjunctionContext ctx) {
        if (ctx.conjunction() != null) {
            Object filterConjunction = this.filter.visitConjunction(ctx.conjunction());
            Object filterBool = this.filter.visitBool(ctx.bool());
            if (((Boolean)((Pair)filterBool).first()).booleanValue() && ((Boolean)((Pair)filterConjunction).first()).booleanValue()) {
                return null;
            }
            if (((Boolean)((Pair)filterBool).first()).booleanValue()) {
                return this.visitConjunction(ctx.conjunction());
            }
            if (((Boolean)((Pair)filterConjunction).first()).booleanValue()) {
                return this.getOriginalText(ctx.bool());
            }
            return String.format("%s AND %s", this.getOriginalText(ctx.bool()), this.getOriginalText(ctx.conjunction()));
        }
        Object bool = this.filter.visitBool(ctx.bool());
        return (Boolean)((Pair)bool).first() != false ? null : this.getOriginalText(ctx.bool());
    }
}

