/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccommons.struct;

import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.time.FastDateFormat;

public class TablespaceDefinition {
    private final List<TableDefinition> tables = new LinkedList<TableDefinition>();
    private TablespaceType tablespaceType = TablespaceType.VSAM;
    private String name;
    private String creator;
    private Timestamp createdTimestamp;
    private Timestamp alteredTimestamp;
    private TablespaceLayout layout = new TablespaceLayout();
    private boolean useDfsortAccess = false;
    private String dfsortOptions = null;
    private int minThreshold = -1;
    private boolean readOnly = false;
    private char csvStringDelimiter = (char)34;
    private char csvColumnDelimiter = (char)44;
    private char csvDecimalDelimiter = (char)46;
    private String csvBooleanTrue = "1";
    private String csvBooleanFalse = "0";
    private boolean csvHeader = true;
    private int csvCacheSize = 0x100000;
    private FastDateFormat timestampFormat = null;
    private FastDateFormat dateFormat = null;
    private FastDateFormat timeFormat = null;
    private CsvQuoteMode csvQuoteMode = CsvQuoteMode.STRINGS;
    private boolean strictEncoding = false;

    public TablespaceDefinition() {
        this.createdTimestamp = new Timestamp(0L);
        this.alteredTimestamp = new Timestamp(0L);
    }

    public boolean isCSVHeader() {
        return this.csvHeader;
    }

    public void setCSVHeader(boolean csvHeader) {
        this.csvHeader = csvHeader;
    }

    public char getCSVStringDelimiter() {
        return this.csvStringDelimiter;
    }

    public void setCSVStringDelimiter(char delimiter) {
        this.csvStringDelimiter = delimiter;
    }

    public char getCSVColumnDelimiter() {
        return this.csvColumnDelimiter;
    }

    public void setCSVColumnDelimiter(char delimiter) {
        this.csvColumnDelimiter = delimiter;
    }

    public FastDateFormat getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setTimestampFormat(String timestampFormatString) {
        this.timestampFormat = FastDateFormat.getInstance(timestampFormatString);
    }

    public FastDateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormatString) {
        this.timeFormat = FastDateFormat.getInstance(timeFormatString);
    }

    public FastDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormatString) {
        this.dateFormat = FastDateFormat.getInstance(dateFormatString);
    }

    public char getCSVDecimalDelimiter() {
        return this.csvDecimalDelimiter;
    }

    public void setCSVDecimalDelimiter(char delimiter) {
        this.csvDecimalDelimiter = delimiter;
    }

    public String getCSVBooleanRepresentation(boolean which) {
        return which ? this.csvBooleanTrue : this.csvBooleanFalse;
    }

    public void setCSVBoolean(boolean which, String delimiter) {
        if (which) {
            this.csvBooleanTrue = delimiter;
        } else {
            this.csvBooleanFalse = delimiter;
        }
    }

    public CsvQuoteMode getCSVQuoteMode() {
        return this.csvQuoteMode;
    }

    public void setCSVQuoteMode(CsvQuoteMode q) {
        this.csvQuoteMode = q;
    }

    public List<TableDefinition> getTables() {
        return this.tables;
    }

    public TablespaceLayout getLayout() {
        return this.layout;
    }

    public void setLayout(TablespaceLayout layout) {
        this.layout = layout;
    }

    public boolean isUseDfsortAccess() {
        return this.useDfsortAccess;
    }

    public void setUseDfsortAccess(boolean useDfsortAccess) {
        this.useDfsortAccess = useDfsortAccess;
    }

    public String getDfsortOptions() {
        return this.dfsortOptions;
    }

    public void setDfsortOptions(String dfsortOptions) {
        this.dfsortOptions = dfsortOptions;
    }

    public int getMinThreshold() {
        return this.minThreshold;
    }

    public void setMinThreshold(int minThreshold) {
        this.minThreshold = minThreshold;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TablespaceDefinition other = (TablespaceDefinition)obj;
        return Objects.equals(this.name, other.name);
    }

    public String getName() {
        return this.name.toUpperCase();
    }

    public void setName(String name) {
        this.name = name != null ? name.toUpperCase() : null;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Timestamp getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(Timestamp createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    public Timestamp getAlteredTimestamp() {
        return this.alteredTimestamp;
    }

    public void setAlteredTimestamp(Timestamp alteredTimestamp) {
        this.alteredTimestamp = alteredTimestamp;
    }

    public TablespaceType getTablespaceType() {
        return this.tablespaceType;
    }

    public void setTablespaceType(TablespaceType newType) {
        this.tablespaceType = newType;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int getCSVCacheSize() {
        return this.csvCacheSize;
    }

    public void setCSVCacheSize(int cacheSize) {
        this.csvCacheSize = cacheSize;
    }

    public boolean isStrictEncoding() {
        return this.strictEncoding;
    }

    public void setStrictEncoding(boolean strictEncoding) {
        this.strictEncoding = strictEncoding;
    }

    public static enum TablespaceType {
        VSAM,
        CSV;

    }

    public static enum CsvQuoteMode {
        ALL,
        STRINGS,
        MINIMAL,
        NONE;

    }
}

