/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccommons.struct;

import de.ubs.jdbcserver.jdbccomm.struct.AbstractItem;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.ItemPath;
import de.ubs.jdbcserver.jdbccomm.struct.Section;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccomm.util.Pair;
import de.ubs.jdbcserver.jdbccommons.struct.MainframeDataTypes;
import de.ubs.xdm.utils.template.TemplateUtilities;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;

public class DefaultTableStatementBuilder {
    private BuilderConfiguration builderConfiguration;

    public DefaultTableStatementBuilder(BuilderConfiguration builderConfiguration) {
        this.builderConfiguration = builderConfiguration;
    }

    public String buildTableStatement() {
        LinkedList<Pair<ItemPath, ColumnSpec>> workingStorage = new LinkedList<Pair<ItemPath, ColumnSpec>>();
        this.buildColumns(workingStorage, this.builderConfiguration.getRootSection());
        LinkedList<ColumnSpec> columns = new LinkedList<ColumnSpec>();
        for (Pair pair : workingStorage) {
            columns.add((ColumnSpec)pair.second());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.builderConfiguration.getTableName());
        map.put("schema", this.builderConfiguration.getTableSchema());
        map.put("columns", columns);
        map.put("tablespace", this.builderConfiguration.getTablespaceName());
        map.put("when", this.builderConfiguration.getWhenCondition());
        try {
            String string = TemplateUtilities.tailor(new InputStreamReader(this.getClass().getResourceAsStream("createTable.ftl"), StandardCharsets.UTF_8), map);
            return string;
        }
        catch (ScriptException scriptException) {
            return null;
        }
    }

    private void buildColumns(List<Pair<ItemPath, ColumnSpec>> outputs, AbstractItem s) {
        this.buildColumns(outputs, new LinkedList<Integer>(), s);
    }

    private void buildColumns(List<Pair<ItemPath, ColumnSpec>> outputs, List<Integer> occurrences, AbstractItem s) {
        if (s.getOccurrenceCounterField() != null) {
            occurrences = new LinkedList<Integer>(occurrences);
            occurrences.add(0);
        }
        for (int i = 0; i < s.getMaximumOccurrences(); ++i) {
            if (s.getOccurrenceCounterField() != null) {
                occurrences.set(occurrences.size() - 1, i + 1);
            }
            if (s instanceof Field) {
                Field field = (Field)s;
                String exp = this.buildColumnExpression(s, occurrences, outputs);
                outputs.add(new Pair<ItemPath, ColumnSpec>(field.getFieldPath(), new ColumnSpec(this.getColumnName(outputs, field), this.determineType(field), field.getFieldPath(), exp)));
                continue;
            }
            if (!(s instanceof Section)) continue;
            Section section = (Section)s;
            for (AbstractItem item : section.getItems()) {
                this.buildColumns(outputs, occurrences, item);
            }
        }
    }

    protected String determineType(Field field) {
        String type = "";
        switch (MainframeDataTypes.valueOf(field.getType())) {
            case STRING: {
                if (field.getName().toUpperCase().equals("FILLER")) {
                    type = "BINARY (" + field.getLength() + ")";
                    break;
                }
                type = "CHAR (" + field.getLength() + ")";
                break;
            }
            case BINARY: {
                type = "BINARY (" + field.getLength() + ")";
                break;
            }
            case SHORT: 
            case UNSIGNED_SHORT: {
                type = "SMALLINT";
                break;
            }
            case LONG: 
            case UNSIGNED_LONG: {
                type = "BIGINT";
                break;
            }
            case INTEGER: 
            case UNSIGNED_INTEGER: {
                type = "INTEGER";
                break;
            }
            case DOUBLE: {
                type = "DOUBLE";
                break;
            }
            case EXTERNAL_FLOAT: 
            case FLOAT: {
                type = "FLOAT";
                break;
            }
            case EXTERNAL_DECIMAL: 
            case PACKED_DECIMAL: 
            case UNSIGNED_PACKED_DECIMAL: {
                type = "DECIMAL (" + field.getLength() + " , " + field.getScale() + ")";
            }
        }
        return type;
    }

    private String buildColumnExpression(AbstractItem item, List<Integer> occurrences, List<Pair<ItemPath, ColumnSpec>> columns) {
        int currentIdx = occurrences.size() - 1;
        LinkedList<String> expressions = new LinkedList<String>();
        AbstractItem parent = item;
        while ((parent = (AbstractItem)parent.getParent()) != null) {
            if (parent.getOccurrenceCounterField() == null) continue;
            Field field = TablespaceLayout.findOccurrenceCounterField(item.getParent(), parent.getOccurrenceCounterField());
            if (field == null) {
                throw new RuntimeException("The occurrence counter field " + parent.getOccurrenceCounterField() + " must be located before " + parent.getFieldPath().toString());
            }
            ColumnSpec matchedColumn = null;
            for (Pair<ItemPath, ColumnSpec> column : columns) {
                if (!column.first().equals(field.getFieldPath())) continue;
                matchedColumn = column.second();
            }
            expressions.add(String.format("\"%s\" >= %d", matchedColumn.getName(), occurrences.get(currentIdx)));
            --currentIdx;
        }
        return expressions.isEmpty() ? null : StringUtils.join(expressions, " AND ");
    }

    private String getColumnName(List<Pair<ItemPath, ColumnSpec>> columns, Field f) {
        return this.getColumnName(columns, f, 1);
    }

    private String getColumnName(List<Pair<ItemPath, ColumnSpec>> columns, Field f, int prefixNo) {
        String fieldName = f.getName();
        if (fieldName.equals("*")) {
            fieldName = "FILLER";
        }
        String supposedName = prefixNo == 1 ? fieldName : String.format("%s-%03d", fieldName, prefixNo);
        for (Pair<ItemPath, ColumnSpec> column : columns) {
            if (!column.second().getName().equals(supposedName)) continue;
            return this.getColumnName(columns, f, prefixNo + 1);
        }
        return supposedName;
    }

    public static class BuilderConfiguration {
        String tablespaceName;
        Section rootSection;
        String tableSchema;
        String tableName;
        String whenCondition;

        public BuilderConfiguration(String tablespaceName, Section rootSection, String tableSchema, String tableName) {
            this.tablespaceName = tablespaceName;
            this.rootSection = rootSection;
            this.tableSchema = tableSchema;
            this.tableName = tableName;
        }

        public BuilderConfiguration whenCondition(String whenCondition) {
            this.whenCondition = whenCondition;
            return this;
        }

        public String getTablespaceName() {
            return this.tablespaceName;
        }

        public Section getRootSection() {
            return this.rootSection;
        }

        public String getTableSchema() {
            return this.tableSchema;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getWhenCondition() {
            return this.whenCondition;
        }
    }

    public static class ColumnSpec {
        private final String name;
        private final String type;
        private final ItemPath uses;
        private final String expression;

        public ColumnSpec(String name, String type, ItemPath uses, String expression) {
            this.name = name;
            this.type = type;
            this.uses = uses;
            this.expression = expression;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getUses() {
            LinkedList<String> strs = new LinkedList<String>();
            for (String use : this.uses.getPathElements()) {
                strs.add("'" + use + "'");
            }
            return StringUtils.join(strs, ".");
        }

        public String getExpression() {
            return this.expression;
        }
    }
}

