/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccommons.struct;

import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccomm.util.ClientSerializer;
import de.ubs.jdbcserver.jdbccommons.struct.DatabaseEngine;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.ParseException;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public abstract class AbstractDatabaseEngine
implements DatabaseEngine {
    private static final FastDateFormat DATE_FORMATTER = FastDateFormat.getInstance("yyyy-MM-dd-HH:mm:ss.SSS");

    protected abstract String read(String var1) throws IOException;

    protected abstract void write(String var1, String var2) throws IOException;

    protected TablespaceDefinition readTablespace(String tablespaceName) throws IOException, JDOMException, ParseException {
        String content = this.read(tablespaceName);
        Document doc = new SAXBuilder().build(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
        FastDateFormat parser = DATE_FORMATTER;
        Element root = doc.getRootElement();
        TablespaceDefinition ts = new TablespaceDefinition();
        ts.setName(tablespaceName);
        ts.setAlteredTimestamp(new Timestamp(parser.parse(root.getAttributeValue("alteredts", "1980-01-01-00:00:00.000")).getTime()));
        ts.setCreatedTimestamp(new Timestamp(parser.parse(root.getAttributeValue("createdts", "1980-01-01-00:00:00.000")).getTime()));
        ts.setCreator(root.getAttributeValue("creator"));
        String tablespaceTypeString = root.getAttributeValue("tablespace-type");
        if (tablespaceTypeString != null) {
            ts.setTablespaceType(TablespaceDefinition.TablespaceType.valueOf(tablespaceTypeString));
        }
        ts.setLayout(ClientSerializer.fromXML(root.getChild("record-descriptor")));
        ts.setUseDfsortAccess("Y".equals(root.getAttributeValue("dfsort", "N")));
        ts.setMinThreshold(Integer.parseInt(root.getAttributeValue("min-threshold", "-1")));
        if (root.getAttributeValue("dfsort-options") != null) {
            ts.setDfsortOptions(root.getAttributeValue("dfsort-options"));
        }
        if (ts.getTablespaceType() == TablespaceDefinition.TablespaceType.CSV) {
            String decpt = root.getAttributeValue("decpt");
            String chardel = root.getAttributeValue("chardel");
            String coldel = root.getAttributeValue("coldel");
            String cacheSizeString = root.getAttributeValue("cache-size");
            String headerString = root.getAttributeValue("header");
            String booleanTrue = root.getAttributeValue("bool-true");
            String booleanFalse = root.getAttributeValue("bool-false");
            String quoteModeString = root.getAttributeValue("quote-mode");
            String strictString = root.getAttributeValue("encoding-strict");
            String readOnlyString = root.getAttributeValue("read-only");
            if (decpt != null && !decpt.isEmpty()) {
                ts.setCSVDecimalDelimiter(decpt.charAt(0));
            }
            if (coldel != null && !coldel.isEmpty()) {
                ts.setCSVColumnDelimiter(coldel.charAt(0));
            }
            if (chardel != null && !chardel.isEmpty()) {
                ts.setCSVStringDelimiter(chardel.charAt(0));
            }
            if (headerString != null) {
                ts.setCSVHeader(Boolean.valueOf(headerString));
            }
            if (booleanTrue != null) {
                ts.setCSVBoolean(true, booleanTrue);
            }
            if (booleanFalse != null) {
                ts.setCSVBoolean(false, booleanFalse);
            }
            if (strictString != null) {
                ts.setStrictEncoding(Boolean.valueOf(strictString));
            }
            if (readOnlyString != null) {
                ts.setReadOnly(Boolean.valueOf(readOnlyString));
            }
            try {
                ts.setCSVCacheSize(Integer.parseInt(cacheSizeString));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                ts.setCSVQuoteMode(TablespaceDefinition.CsvQuoteMode.valueOf(quoteModeString));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (Element children : root.getChildren("table-definition")) {
            TableDefinition td = ClientSerializer.tableDefinitionFromXML(children);
            td.setTablespaceName(tablespaceName);
            ts.getTables().add(td);
        }
        return ts;
    }

    @Override
    public void updateTablespace(TablespaceDefinition tablespace) throws IOException {
        TablespaceLayout layout = tablespace.getLayout();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Element element = ClientSerializer.toXML(layout);
        Element root = new Element("structure");
        root.setAttribute("createdts", DATE_FORMATTER.format(tablespace.getCreatedTimestamp()));
        root.setAttribute("alteredts", DATE_FORMATTER.format(tablespace.getAlteredTimestamp()));
        root.setAttribute("creator", tablespace.getCreator());
        root.setAttribute("tablespace-type", tablespace.getTablespaceType().name());
        if (layout.getFileName() != null) {
            root.setAttribute("fileName", layout.getFileName());
        }
        root.setAttribute("min-threshold", String.valueOf(tablespace.getMinThreshold()));
        root.setAttribute("dfsort", tablespace.isUseDfsortAccess() ? "Y" : "N");
        if (tablespace.getDfsortOptions() != null) {
            root.setAttribute("dfsort-options", tablespace.getDfsortOptions());
        }
        if (tablespace.getTablespaceType() == TablespaceDefinition.TablespaceType.CSV) {
            root.setAttribute("decpt", Character.toString(tablespace.getCSVDecimalDelimiter()));
            root.setAttribute("coldel", Character.toString(tablespace.getCSVColumnDelimiter()));
            root.setAttribute("chardel", Character.toString(tablespace.getCSVStringDelimiter()));
            root.setAttribute("cache-size", Integer.toString(tablespace.getCSVCacheSize()));
            root.setAttribute("header", Boolean.toString(tablespace.isCSVHeader()));
            root.setAttribute("bool-true", tablespace.getCSVBooleanRepresentation(true));
            root.setAttribute("bool-false", tablespace.getCSVBooleanRepresentation(false));
            root.setAttribute("quote-mode", tablespace.getCSVQuoteMode().name());
            root.setAttribute("encoding-strict", Boolean.toString(tablespace.isStrictEncoding()));
            root.setAttribute("read-only", Boolean.toString(tablespace.isReadOnly()));
        }
        root.addContent(element);
        for (TableDefinition td : tablespace.getTables()) {
            root.addContent(ClientSerializer.toXML(td));
        }
        new XMLOutputter(Format.getPrettyFormat()).output(root, (OutputStream)out);
        this.write(tablespace.getName(), new String(out.toByteArray(), StandardCharsets.UTF_8));
    }
}

