/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccommons.pl1;

import de.ubs.jdbcserver.jdbccomm.struct.AbstractItem;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.Section;
import de.ubs.jdbcserver.jdbccommons.pl1.PL1Attributes;
import de.ubs.jdbcserver.jdbccommons.pl1.PL1Utils;
import de.ubs.jdbcserver.jdbccommons.pl1.PL1declBaseVisitor;
import de.ubs.jdbcserver.jdbccommons.pl1.PL1declException;
import de.ubs.jdbcserver.jdbccommons.pl1.PL1declParser;
import de.ubs.jdbcserver.jdbccommons.struct.MainframeDataTypes;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class PL1declNodeVisitor
extends PL1declBaseVisitor<Object> {
    private List<AbstractItem> levelOneItemList = new LinkedList<AbstractItem>();

    public List<AbstractItem> getLevelOneItemList() {
        return this.levelOneItemList;
    }

    @Override
    public Object visitDeclStmtList(PL1declParser.DeclStmtListContext ctx) {
        PL1Utils.setTraceLogLevel("Finest");
        this.writeTraceLog("visitDeclStmtList(), child ct = " + ctx.getChildCount());
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        for (PL1declParser.DeclStmtContext declStmt : ctx.declStmt()) {
            this.visitDeclStmt(declStmt);
        }
        PL1Utils.setTraceLogLevel("OFF");
        return this.getLevelOneItemList();
    }

    @Override
    public Object visitDeclStmt(PL1declParser.DeclStmtContext ctx) {
        this.writeTraceLog("visitDeclStmt()");
        this.visitDeclList(ctx.declList());
        return null;
    }

    @Override
    public List<AbstractItem> visitDeclList(PL1declParser.DeclListContext ctx) {
        this.writeTraceLog("visitDeclList(), child ct = " + ctx.getChildCount());
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        SectionLevelStack<LevelElement> sectionStack = new SectionLevelStack<LevelElement>();
        int currLevel = 0;
        int prevLevel = 0;
        int declNum = 0;
        AbstractItem currItem = null;
        for (PL1declParser.DeclItemContext declItem : ctx.declItem()) {
            PL1declException ex;
            String msg;
            String logMsg = "declItem = " + declItem.getText() + "\n  ID = " + (declItem.ID() != null ? declItem.ID().getText() : "undefined") + ", child ct = " + declItem.getChildCount() + ", level number = " + (declItem.INT() != null ? declItem.INT().getText() : "undefined");
            this.writeTraceLog(logMsg);
            for (int n = 0; n < declItem.getChildCount(); ++n) {
                this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)declItem.children.get(n)).getText());
            }
            ++declNum;
            prevLevel = sectionStack.getCurrItemLevel();
            currLevel = declItem.INT() != null ? Integer.parseInt(declItem.INT().getText()) : 1;
            List<Object> dimensions = new ArrayList();
            boolean isField = true;
            if (declItem.attrList() == null) {
                isField = false;
            } else if (declItem.attrList().dataAttr() == null) {
                isField = false;
            } else if (declItem.dimAttr() != null && declItem.dimAttr().DIMACROSS() != null) {
                isField = false;
            } else {
                for (PL1declParser.DataAttrContext da : declItem.attrList().dataAttr()) {
                    if (da.numericAttr() != null || da.stringAttr() != null || da.pictAttr() != null || da.areaAttr() != null || da.initAttr() != null) continue;
                    isField = false;
                    break;
                }
            }
            if (declItem.dimAttr() != null) {
                dimensions = this.processDimensions(declItem.dimAttr());
            } else if (declItem.attrList() != null && declItem.attrList().DIMENSION().size() > 0) {
                dimensions = this.processDimensions(declItem.attrList().dimAttr(0));
            }
            if (currLevel == 1) {
                this.writeTraceLog("currLevel == 1");
                while (!sectionStack.isEmpty()) {
                    this.removeSectionStackElement(sectionStack);
                }
                if (isField) {
                    this.writeTraceLog("isField == true");
                    currItem = dimensions.isEmpty() ? this.makeField(declItem, sectionStack) : this.makeFieldWithDimensions(declItem, dimensions, sectionStack);
                } else {
                    this.writeTraceLog("isField == false");
                    currItem = dimensions.isEmpty() ? this.makeSection(declItem, sectionStack) : this.makeSectionWithDimensions(declItem, dimensions, sectionStack);
                }
                this.levelOneItemList.add(currItem);
                continue;
            }
            if (sectionStack.isEmpty()) {
                msg = "Read level " + currLevel + " item " + declItem.ID().getText() + ", but no parent found in the stack (empty).";
                ex = new PL1declException(msg);
                throw new RuntimeException("Error - Declaration item " + declNum, ex);
            }
            if (currLevel > prevLevel) {
                this.writeTraceLog("currLevel > prevLevel");
                if (isField) {
                    if (dimensions.isEmpty()) {
                        currItem = this.makeField(declItem, sectionStack);
                        continue;
                    }
                    currItem = this.makeFieldWithDimensions(declItem, dimensions, sectionStack);
                    continue;
                }
                if (dimensions.isEmpty()) {
                    currItem = this.makeSection(declItem, sectionStack);
                    continue;
                }
                currItem = this.makeSectionWithDimensions(declItem, dimensions, sectionStack);
                continue;
            }
            this.writeTraceLog("currLevel <= prevLevel");
            while (currLevel <= sectionStack.getCurrItemLevel()) {
                this.removeSectionStackElement(sectionStack);
            }
            if (sectionStack.isEmpty()) {
                msg = "Read level " + currLevel + " item " + declItem.ID().getText() + ", but no parent found in the stack (empty).";
                ex = new PL1declException(msg);
                throw new RuntimeException("Error - Declaration item " + declNum, ex);
            }
            if (isField) {
                if (dimensions.isEmpty()) {
                    currItem = this.makeField(declItem, sectionStack);
                    continue;
                }
                currItem = this.makeFieldWithDimensions(declItem, dimensions, sectionStack);
                continue;
            }
            if (dimensions.isEmpty()) {
                currItem = this.makeSection(declItem, sectionStack);
                continue;
            }
            currItem = this.makeSectionWithDimensions(declItem, dimensions, sectionStack);
        }
        return null;
    }

    private void removeSectionStackElement(SectionLevelStack<LevelElement> stack) {
        this.writeTraceLog("pop: " + stack.getCurrStackItem().getName() + ", level = " + stack.getCurrItemLevel() + ", type = " + stack.getCurrStackElement().getType());
        LevelElement elt = stack.popStack();
        if (elt.getType() != null && elt.getType().equals(PL1Attributes.UNION.name())) {
            AbstractItem redefItem = null;
            boolean n = false;
            for (AbstractItem item : ((Section)elt.getItem()).getItems()) {
                if (redefItem == null) {
                    redefItem = item;
                    continue;
                }
                item.setRedefine(redefItem.getName());
            }
        }
    }

    private List<Object> processDimensions(PL1declParser.DimAttrContext dimCtx) {
        String logMsg = "processDimensions(" + dimCtx.getText() + ")  size = " + (dimCtx.boundSpec() != null ? Integer.valueOf(dimCtx.boundSpec().size()) : "unknown");
        this.writeTraceLog(logMsg);
        ArrayList<Object> lo = new ArrayList<Object>();
        if (dimCtx.boundSpec().size() >= 1) {
            for (PL1declParser.BoundSpecContext bounds : dimCtx.boundSpec()) {
                if (bounds.lowerBound() != null && bounds.lowerBound().referSpec() != null) {
                    String lwr = bounds.lowerBound().referSpec().ID().getText();
                    String upr = bounds.upperBound().referSpec() != null ? bounds.upperBound().referSpec().ID().getText() : this.visitExpr(bounds.upperBound().expr()).toString();
                    lo.add(lwr + ";" + upr);
                    continue;
                }
                if (bounds.upperBound().referSpec() != null) {
                    int lwr = bounds.lowerBound() == null ? 1 : (Integer)this.visitExpr(bounds.lowerBound().expr());
                    lo.add(lwr + ";" + bounds.upperBound().referSpec());
                    continue;
                }
                int lwr = bounds.lowerBound() == null ? 1 : (Integer)this.visitExpr(bounds.lowerBound().expr());
                int upr = (Integer)this.visitExpr(bounds.upperBound().expr());
                lo.add(1 + upr - lwr);
            }
        }
        return lo;
    }

    private AlignmentState getAlignmentState(PL1declParser.DeclItemContext declItem, SectionLevelStack<LevelElement> stack) {
        if (declItem.attrList() != null && declItem.attrList().dataAttr() != null) {
            for (PL1declParser.DataAttrContext attr : declItem.attrList().dataAttr()) {
                if (attr.litDataAttr() == null) continue;
                if (attr.litDataAttr().ALIGNED() != null) {
                    return AlignmentState.ALIGNED;
                }
                if (attr.litDataAttr().UNALIGNED() == null) continue;
                return AlignmentState.UNALIGNED;
            }
        }
        if (!stack.isEmpty()) {
            return stack.getCurrStackElement().getAlignmentState();
        }
        return AlignmentState.DEFAULT;
    }

    private int getAlignment(String type, int storeLen, AlignmentState state) {
        if (type.equals("VARYING2")) {
            return 2;
        }
        if (type.equals("VARYING4")) {
            return 4;
        }
        if (type.equals("BIT")) {
            return -1;
        }
        if (state.equals((Object)AlignmentState.DEFAULT)) {
            state = type.equals(MainframeDataTypes.STRING.name()) || type.equals(MainframeDataTypes.PACKED_DECIMAL.name()) ? AlignmentState.UNALIGNED : AlignmentState.ALIGNED;
        }
        if (state.equals((Object)AlignmentState.ALIGNED)) {
            if (type.equals(MainframeDataTypes.BINARY.name()) || type.equals(MainframeDataTypes.FLOAT.name())) {
                if (storeLen > 4) {
                    return 8;
                }
                if (storeLen > 2) {
                    return 4;
                }
                if (storeLen > 1) {
                    return 2;
                }
                return 1;
            }
            if (type.equals(MainframeDataTypes.POINTER.name())) {
                return 4;
            }
        }
        return -1;
    }

    private Field makeField(PL1declParser.DeclItemContext declItem, SectionLevelStack<LevelElement> stack) {
        AbstractItem parentItem = stack.isEmpty() ? null : stack.getCurrStackItem();
        this.writeTraceLog("makeField(" + (declItem.ID() == null ? "*" : declItem.ID().getText()) + "), parent = " + (parentItem == null ? "null" : parentItem.getName()));
        Field f = null;
        List attrVals = null;
        for (PL1declParser.DataAttrContext attr : declItem.attrList().dataAttr()) {
            if (attr.stringAttr() != null) {
                attrVals = (List)this.visitStringAttr(attr.stringAttr());
                continue;
            }
            if (attr.numericAttr() != null) {
                attrVals = (List)this.visitNumericAttr(attr.numericAttr());
                continue;
            }
            if (attr.pictAttr() == null) continue;
            this.writeTraceLog("pictSpec = " + this.visitPictAttr(attr.pictAttr()).toString());
            System.out.println("pictSpec = " + this.visitPictAttr(attr.pictAttr()).toString());
        }
        if (attrVals != null) {
            int alignment = this.getAlignment((String)attrVals.get(0), (Integer)attrVals.get(2), this.getAlignmentState(declItem, stack));
            if (attrVals.get(0).equals("BIT")) {
                attrVals.set(0, MainframeDataTypes.BINARY.name());
            }
            f = new Field(parentItem, declItem.ID() == null ? "*" : declItem.ID().getText(), (String)attrVals.get(0), (Integer)attrVals.get(1), (Integer)attrVals.get(2), (Integer)attrVals.get(3));
            f.setAlignment(alignment);
            if (parentItem != null) {
                ((Section)parentItem).addItem(f);
            }
        }
        return f;
    }

    private Section makeSection(PL1declParser.DeclItemContext declItem, SectionLevelStack<LevelElement> stack) {
        AbstractItem parentItem = stack.isEmpty() ? null : stack.getCurrStackItem();
        this.writeTraceLog("makeSection(" + (declItem.ID() == null ? "*" : declItem.ID().getText()) + ", " + (declItem.INT() != null ? Integer.parseInt(declItem.INT().getText()) : 1) + "), parent = " + (parentItem != null ? parentItem.getName() : "null"));
        int currLevel = declItem.INT() != null ? Integer.parseInt(declItem.INT().getText()) : 1;
        Section section = new Section(parentItem, declItem.ID() == null ? "*" : declItem.ID().getText());
        stack.pushStack(section, currLevel, this.getAlignmentState(declItem, stack));
        if (declItem.attrList() != null && declItem.attrList().dataAttr().size() > 0) {
            for (PL1declParser.DataAttrContext attr : declItem.attrList().dataAttr()) {
                if (attr.litDataAttr() == null || attr.litDataAttr().UNION() == null && attr.litDataAttr().CELL() == null) continue;
                stack.getCurrStackElement().setType(PL1Attributes.UNION.name());
            }
        }
        if (parentItem != null) {
            ((Section)parentItem).addItem(section);
        }
        return section;
    }

    private AbstractItem makeFieldWithDimensions(PL1declParser.DeclItemContext declItem, List<Object> dimensions, SectionLevelStack<LevelElement> stack) {
        Object obj;
        AbstractItem parentItem = stack.isEmpty() ? null : stack.getCurrStackItem();
        this.writeTraceLog("makeFieldWithDimensions(, " + declItem.ID().getText() + ", dimensions[0 .. " + (dimensions.size() - 1) + "], stack[0 .. " + (stack.size() - 1) + "]), parent = " + (parentItem != null ? parentItem.getName() : "null"));
        Section section = null;
        Section currItem = null;
        AlignmentState al = this.getAlignmentState(declItem, stack);
        if (dimensions.size() > 1) {
            for (int n = 0; n < dimensions.size() - 1; ++n) {
                int currLevel = declItem.INT() != null ? Integer.parseInt(declItem.INT().getText()) : 1;
                obj = dimensions.get(n);
                currItem = new Section(parentItem, declItem.ID().getText() + "_" + n);
                if (obj instanceof Integer) {
                    currItem.setMaximumOccurrences((Integer)obj);
                } else {
                    currItem.setOccurrencesField(obj.toString());
                }
                if (n == 0) {
                    section = currItem;
                }
                stack.pushStack(currItem, currLevel, al);
                if (parentItem != null) {
                    ((Section)parentItem).addItem(currItem);
                }
                parentItem = currItem;
            }
        }
        Field field = this.makeField(declItem, stack);
        obj = dimensions.get(dimensions.size() - 1);
        if (obj instanceof Integer) {
            field.setMaximumOccurrences((Integer)obj);
        } else {
            field.setOccurrencesField(obj.toString());
        }
        if (section == null) {
            return field;
        }
        return section;
    }

    private AbstractItem makeSectionWithDimensions(PL1declParser.DeclItemContext declItem, List<Object> dimensions, SectionLevelStack<LevelElement> stack) {
        AbstractItem parentItem = stack.isEmpty() ? null : stack.getCurrStackItem();
        this.writeTraceLog("makeSectionWithDimensions(, " + declItem.ID().getText() + ", dimensions[0 .. " + (dimensions.size() - 1) + "], stack[0 .. " + (stack.size() - 1) + "]), parent = " + (parentItem != null ? parentItem.getName() : "null"));
        Section section = null;
        Section currItem = null;
        for (int n = 0; n < dimensions.size(); ++n) {
            int currLevel = declItem.INT() != null ? Integer.parseInt(declItem.INT().getText()) : 1;
            Object obj = dimensions.get(n);
            String ident = declItem.ID() == null ? "*" : declItem.ID().getText();
            currItem = n == 0 ? new Section(parentItem, ident) : new Section(parentItem, ident + "_" + n);
            if (obj instanceof Integer) {
                currItem.setMaximumOccurrences((Integer)obj);
            } else {
                currItem.setOccurrencesField(obj.toString());
            }
            if (n == 0) {
                section = currItem;
            }
            stack.pushStack(currItem, currLevel, this.getAlignmentState(declItem, stack));
            if (declItem.attrList() != null && declItem.attrList().dataAttr().size() > 0) {
                for (PL1declParser.DataAttrContext attr : declItem.attrList().dataAttr()) {
                    if (attr.litDataAttr() == null || attr.litDataAttr().UNION() == null || attr.litDataAttr().CELL() == null) continue;
                    stack.getCurrStackElement().setType(PL1Attributes.UNION.name());
                }
            }
            if (parentItem != null) {
                ((Section)parentItem).addItem(currItem);
            }
            parentItem = currItem;
        }
        return section;
    }

    @Override
    public AbstractItem visitDeclItem(PL1declParser.DeclItemContext ctx) {
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.visit((ParseTree)ctx.children.get(n));
        }
        return null;
    }

    @Override
    public AbstractItem visitAttrList(PL1declParser.AttrListContext ctx) {
        this.writeTraceLog("attrList = " + ctx.getText() + ", child ct = " + ctx.getChildCount());
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        this.visitChildren(ctx);
        return null;
    }

    @Override
    public AbstractItem visitDataAttr(PL1declParser.DataAttrContext ctx) {
        this.writeTraceLog("dataAttr = " + ctx.getText() + ", child ct = " + ctx.getChildCount());
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        this.visitChildren(ctx);
        return null;
    }

    @Override
    public AbstractItem visitInitAttr(PL1declParser.InitAttrContext ctx) {
        this.writeTraceLog("initAttr = " + ctx.getText() + ", child ct = " + ctx.getChildCount());
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        this.visitChildren(ctx);
        return null;
    }

    @Override
    public AbstractItem visitInitItemList(PL1declParser.InitItemListContext ctx) {
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        this.visitChildren(ctx);
        return null;
    }

    @Override
    public AbstractItem visitInitItem(PL1declParser.InitItemContext ctx) {
        this.writeTraceLog("initItem = " + ctx.getText() + ", child ct = " + ctx.getChildCount());
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        this.visitChildren(ctx);
        return null;
    }

    @Override
    public Object visitNumericAttr(PL1declParser.NumericAttrContext ctx) {
        this.writeTraceLog("visitNumericAttr(" + ctx.getText() + ")");
        int dlen = 0;
        int slen = 0;
        int scale = 0;
        String type = null;
        ArrayList<Object> lobj = new ArrayList<Object>(4);
        boolean tpbinary = false;
        boolean tpcomplex = false;
        boolean tpfloat = false;
        boolean unsigned = false;
        StringBuilder sb = new StringBuilder();
        for (PL1declParser.LitNumAttrContext lit : ctx.litNumAttr()) {
            sb.append(lit.getText());
            if (lit.BINARY() != null) {
                tpbinary = true;
            }
            if (lit.FLOAT() != null) {
                tpfloat = true;
            }
            if (lit.COMPLEX() != null) {
                tpcomplex = true;
            }
            if (lit.UNSIGNED() == null) continue;
            unsigned = true;
        }
        this.writeTraceLog("litNumAttr = " + sb.toString() + "\n    tpbinary = " + tpbinary + ", tpfloat = " + tpfloat);
        if (tpcomplex) {
            String msg = "Complex expressions not supported.";
            PL1declException ex = new PL1declException(msg);
            throw new RuntimeException("Unsupported declaration attributes: " + ((PL1declParser.DeclItemContext)ctx.getParent().getParent().getParent()).ID().getText(), ex);
        }
        if (tpbinary) {
            dlen = Integer.parseInt(ctx.precision().INT().get(0).getText());
            this.writeTraceLog("  BINARY display length = " + dlen);
            if (tpfloat) {
                if (dlen <= 21) {
                    slen = 4;
                    type = MainframeDataTypes.FLOAT.name();
                } else {
                    slen = dlen <= 53 ? 8 : 16;
                    type = MainframeDataTypes.DOUBLE.name();
                }
            } else {
                if (ctx.precision().INT().size() > 1) {
                    scale = Integer.parseInt(ctx.precision().INT().get(1).getText());
                }
                if (unsigned) {
                    if (dlen <= 8) {
                        slen = 1;
                        type = MainframeDataTypes.BINARY.name();
                    } else if (dlen <= 16) {
                        slen = 2;
                        type = MainframeDataTypes.UNSIGNED_SHORT.name();
                    } else if (dlen <= 32) {
                        slen = 4;
                        type = MainframeDataTypes.UNSIGNED_INTEGER.name();
                    } else {
                        slen = 8;
                        type = MainframeDataTypes.UNSIGNED_LONG.name();
                    }
                } else if (dlen <= 7) {
                    slen = 1;
                    type = MainframeDataTypes.BINARY.name();
                } else if (dlen <= 15) {
                    slen = 2;
                    type = MainframeDataTypes.SHORT.name();
                } else if (dlen <= 31) {
                    slen = 4;
                    type = MainframeDataTypes.INTEGER.name();
                } else {
                    slen = 8;
                    type = MainframeDataTypes.LONG.name();
                }
            }
        } else {
            dlen = Integer.parseInt(ctx.precision().INT().get(0).getText());
            this.writeTraceLog("  DECIMAL display length = " + dlen);
            if (tpfloat) {
                if (dlen <= 6) {
                    slen = 4;
                    type = MainframeDataTypes.FLOAT.name();
                } else {
                    slen = dlen <= 15 ? 8 : 16;
                    type = MainframeDataTypes.DOUBLE.name();
                }
            } else {
                type = MainframeDataTypes.PACKED_DECIMAL.name();
                if (ctx.precision().INT().size() > 1) {
                    scale = Integer.parseInt(ctx.precision().INT().get(1).getText());
                }
                slen = dlen / 2 + 1;
            }
        }
        lobj.add(type);
        lobj.add(slen);
        lobj.add(dlen);
        lobj.add(scale);
        return lobj;
    }

    @Override
    public Object visitPictAttr(PL1declParser.PictAttrContext ctx) {
        if (ctx.CHARSTRING() != null) {
            return ctx.CHARSTRING().getText();
        }
        if (ctx.QCHARSTRING() != null) {
            return ctx.QCHARSTRING().getText();
        }
        return "null";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object visitStringAttr(PL1declParser.StringAttrContext ctx) {
        this.writeTraceLog("visitStringAttr(" + ctx.getText() + ")");
        int dlen = 0;
        int slen = 0;
        String sref = null;
        String type = MainframeDataTypes.STRING.name();
        ArrayList<Object> lobj = new ArrayList<Object>(4);
        this.writeTraceLog("stringAttr = " + ctx.getText() + ", child ct = " + ctx.getChildCount());
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        if (ctx.lengthSpec().ASTER() != null) {
            String msg = "Unsupported length specification: *";
            PL1declException ex = new PL1declException(msg);
            throw new RuntimeException("Unsupported declaration attributes: " + ((PL1declParser.DeclItemContext)ctx.getParent().getParent().getParent()).ID().getText(), ex);
        }
        if (ctx.referSpec() != null) {
            sref = ctx.referSpec().ID().getText();
        }
        if (ctx.BIT() != null) {
            type = MainframeDataTypes.BINARY.name();
            Object obj = this.visitExpr(ctx.lengthSpec().expr());
            if (obj instanceof Number) {
                dlen = ((Number)obj).intValue();
                slen = dlen % 8 == 0 ? dlen / 8 : dlen / 8 + 1;
            } else if (sref == null) {
                String msg = "Expression \"" + ctx.lengthSpec().expr().getText() + "\" cannot be resolved.";
                PL1declException ex = new PL1declException(msg);
                throw new RuntimeException("Unsupported declaration attributes: " + ((PL1declParser.DeclItemContext)ctx.getParent().getParent().getParent()).ID().getText(), ex);
            }
        } else if (ctx.CHARACTER() != null) {
            Object obj = this.visitExpr(ctx.lengthSpec().expr());
            if (!(obj instanceof Number)) {
                String msg = "Expression \"" + ctx.lengthSpec().expr().getText() + "\" cannot be resolved.";
                PL1declException ex = new PL1declException(msg);
                throw new RuntimeException("Unsupported declaration attributes: " + ((PL1declParser.DeclItemContext)ctx.getParent().getParent().getParent()).ID().getText(), ex);
            }
            dlen = slen = Integer.valueOf(((Number)obj).intValue()).intValue();
        } else if (ctx.WIDECHAR() != null || ctx.GRAPHIC() != null) {
            Object obj = this.visitExpr(ctx.lengthSpec().expr());
            if (!(obj instanceof Number)) {
                String msg = "Expression \"" + ctx.lengthSpec().expr().getText() + "\" cannot be resolved.";
                PL1declException ex = new PL1declException(msg);
                throw new RuntimeException("Unsupported declaration attributes: " + ((PL1declParser.DeclItemContext)ctx.getParent().getParent().getParent()).ID().getText(), ex);
            }
            dlen = ((Number)obj).intValue();
            slen = dlen * 2;
        }
        if (ctx.VARYING() != null) {
            slen += 2;
            type = MainframeDataTypes.VARYING2.name();
        } else if (ctx.VARYING4() != null) {
            slen += 4;
            type = MainframeDataTypes.VARYING4.name();
        } else if (ctx.VARYINGZ() != null) {
            slen = ctx.WIDECHAR() != null || ctx.GRAPHIC() != null ? (slen += 2) : ++slen;
            type = MainframeDataTypes.NULL_TERMINATED_STRING.name();
        }
        lobj.add(type);
        lobj.add(slen);
        lobj.add(dlen);
        lobj.add(0);
        return lobj;
    }

    @Override
    public AbstractItem visitString(PL1declParser.StringContext ctx) {
        this.writeTraceLog("string = " + ctx.getText() + ", child ct = " + ctx.getChildCount());
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        this.visitChildren(ctx);
        return null;
    }

    @Override
    public Object visitLengthSpec(PL1declParser.LengthSpecContext ctx) {
        this.writeTraceLog("lengthSpec = " + ctx.getText() + ", child ct = " + ctx.getChildCount());
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        this.visitChildren(ctx);
        return null;
    }

    @Override
    public Object visitExpr(PL1declParser.ExprContext ctx) {
        Object obj = null;
        this.writeTraceLog("expr = " + ctx.getText() + ", child ct = " + ctx.getChildCount());
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        if (ctx.numExpr() != null) {
            obj = this.visitNumExpr(ctx.numExpr());
        } else if (ctx.constant() != null) {
            obj = this.visitConstant(ctx.constant());
        } else if (ctx.reference() != null) {
            obj = this.visitReference(ctx.reference());
        }
        return obj;
    }

    @Override
    public Object visitNumExpr(PL1declParser.NumExprContext ctx) {
        Object obj = null;
        this.writeTraceLog("numExpr = " + ctx.getText() + ", child ct = " + ctx.getChildCount());
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        if (ctx.getChildCount() > 1) {
            Object lhs = this.visit((ParseTree)ctx.children.get(0));
            Object rhs = this.visit((ParseTree)ctx.children.get(2));
            return this.evalAdd(lhs, rhs, ctx.addOp(0));
        }
        return this.visit((ParseTree)ctx.children.get(0));
    }

    @Override
    public Object visitMultExpr(PL1declParser.MultExprContext ctx) {
        this.writeTraceLog("multExpr = " + ctx.getText() + ", child ct = " + ctx.getChildCount());
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        if (ctx.getChildCount() > 1) {
            Object lhs = this.visit((ParseTree)ctx.children.get(0));
            Object rhs = this.visit((ParseTree)ctx.children.get(2));
            return this.evalMult(lhs, rhs, ctx.multOp(0));
        }
        return this.visit((ParseTree)ctx.children.get(0));
    }

    @Override
    public Object visitPowerExpr(PL1declParser.PowerExprContext ctx) {
        this.writeTraceLog("powerExpr = " + ctx.getText() + ", child ct = " + ctx.getChildCount());
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        if (ctx.getChildCount() > 1) {
            Object lhs = this.visit((ParseTree)ctx.children.get(0));
            Object rhs = this.visit((ParseTree)ctx.children.get(2));
            return this.evalPower(lhs, rhs, ctx.powerOp(0));
        }
        return this.visit((ParseTree)ctx.children.get(0));
    }

    @Override
    public Object visitAtomicExpr(PL1declParser.AtomicExprContext ctx) {
        this.writeTraceLog("atomicExpr = " + ctx.getText() + ", child ct = " + ctx.getChildCount());
        if (ctx.numExpr() != null) {
            this.writeTraceLog("    numExpr() = " + ctx.numExpr().getText());
        }
        for (int n = 0; n < ctx.getChildCount(); ++n) {
            this.writeTraceLog("    child(" + n + ")   = " + ((ParseTree)ctx.children.get(n)).getText());
        }
        if (ctx.getChildCount() > 1) {
            if (((ParseTree)ctx.children.get(0)).getText().equals("-")) {
                Object x = this.visit((ParseTree)ctx.children.get(2));
                if (x instanceof String) {
                    return "-(" + x + ")";
                }
                if (x instanceof Integer) {
                    return -1 * (Integer)x;
                }
                return -1.0 * (Double)x;
            }
            if (((ParseTree)ctx.children.get(0)).getText().equals("+")) {
                Object x = this.visit((ParseTree)ctx.children.get(2));
                if (x instanceof String) {
                    return "+(" + x + ")";
                }
                if (x instanceof Integer) {
                    return (Integer)x;
                }
                return (Double)x;
            }
            if (((ParseTree)ctx.children.get(0)).getText().equals("(")) {
                Object x = this.visit((ParseTree)ctx.children.get(1));
                if (x instanceof Integer) {
                    return (Integer)x;
                }
                return (Double)x;
            }
        } else if (ctx.ID() != null) {
            return ctx.ID().getText();
        }
        return this.visitNumber(ctx.number());
    }

    @Override
    public Object visitNumber(PL1declParser.NumberContext ctx) {
        this.writeTraceLog("number = " + ctx.getText());
        String numStr = ctx.getText();
        if (numStr.indexOf(46) >= 0 || numStr.indexOf(69) > 0) {
            return new Double(numStr);
        }
        return new Integer(numStr);
    }

    private Object evalAdd(Object lhs, Object rhs, PL1declParser.AddOpContext ctx) {
        this.writeTraceLog("evalAdd(" + lhs.toString() + ", " + rhs.toString() + ", " + (ctx.MINUS() == null ? "+" : "-") + ")");
        if (lhs instanceof String || rhs instanceof String) {
            return lhs.toString() + (ctx.PLUS() == null ? " - " : " + ") + rhs.toString();
        }
        if (lhs instanceof Double || rhs instanceof Double) {
            Double dlhs = lhs instanceof Double ? (Double)lhs : new Double(lhs.toString());
            Double drhs = rhs instanceof Double ? (Double)rhs : new Double(rhs.toString());
            return this.realAdd(dlhs, drhs, ctx);
        }
        return this.intAdd((Integer)lhs, (Integer)rhs, ctx);
    }

    private Integer intAdd(Integer i, Integer j, PL1declParser.AddOpContext ctx) {
        return ctx.PLUS() == null ? i - j : i + j;
    }

    private Double realAdd(Double x, Double y, PL1declParser.AddOpContext ctx) {
        return ctx.PLUS() == null ? x - y : x + y;
    }

    private Object evalMult(Object lhs, Object rhs, PL1declParser.MultOpContext ctx) {
        this.writeTraceLog("evalMult(" + lhs.toString() + ", " + rhs.toString() + ", " + (ctx.ASTER() == null ? "/" : "*") + ")");
        if (lhs instanceof String || rhs instanceof String) {
            return lhs.toString() + (ctx.ASTER() == null ? " / " : " * ") + rhs.toString();
        }
        if (lhs instanceof Integer && rhs instanceof Integer) {
            return this.intMult((Integer)lhs, (Integer)rhs, ctx);
        }
        Double dlhs = lhs instanceof Double ? (Double)lhs : new Double(lhs.toString());
        Double drhs = rhs instanceof Double ? (Double)rhs : new Double(rhs.toString());
        return this.realMult(dlhs, drhs, ctx);
    }

    private Object intMult(Integer i, Integer j, PL1declParser.MultOpContext ctx) {
        if (ctx.SLASH() == null) {
            return new Integer(i * j);
        }
        if (i % j == 0) {
            return new Integer(i / j);
        }
        return new Double(i / j);
    }

    private Double realMult(Double x, Double y, PL1declParser.MultOpContext ctx) {
        if (ctx.SLASH() == null) {
            return x * y;
        }
        return x / y;
    }

    private Object evalPower(Object lhs, Object rhs, PL1declParser.PowerOpContext ctx) {
        this.writeTraceLog("evalPower(" + lhs.toString() + ", " + rhs.toString() + ", " + ctx.getText() + ")");
        if (lhs instanceof String || rhs instanceof String) {
            return lhs.toString() + " ** " + rhs.toString();
        }
        Double dlhs = lhs instanceof Double ? (Double)lhs : new Double(lhs.toString());
        Double drhs = rhs instanceof Double ? (Double)rhs : new Double(rhs.toString());
        return Math.pow(dlhs, drhs);
    }

    private void writeTestLog(String msg) {
        PL1Utils.writeTestLog(msg);
    }

    private void writeTraceLog(String msg) {
        PL1Utils.writeTraceLog(msg);
    }

    static class SectionLevelStack<T>
    extends ArrayList<LevelElement> {
        int stackIdx = -1;

        SectionLevelStack() {
        }

        public void pushStack(AbstractItem item, int level, AlignmentState al) {
            ++this.stackIdx;
            this.add(new LevelElement(item, level, al));
        }

        public void pushStack(LevelElement elt) {
            ++this.stackIdx;
            this.add(elt);
        }

        public LevelElement popStack() {
            LevelElement elt = null;
            if (this.stackIdx < 0) {
                throw new RuntimeException("Stack underflow in popStack()");
            }
            elt = (LevelElement)this.remove(this.stackIdx);
            --this.stackIdx;
            return elt;
        }

        public LevelElement getCurrStackElement() {
            if (this.isEmpty()) {
                throw new RuntimeException("Stack underflow in getCurrStackElement()");
            }
            return (LevelElement)this.get(this.stackIdx);
        }

        public AbstractItem getCurrStackItem() {
            return this.getCurrStackElement().getItem();
        }

        public int getCurrItemLevel() {
            if (this.isEmpty()) {
                return 0;
            }
            return this.getCurrStackElement().getLevel();
        }

        public LevelElement getPrevStackElement() {
            if (this.stackIdx <= 0) {
                throw new RuntimeException("Stack underflow in getPrevStackElement()");
            }
            return (LevelElement)this.get(this.stackIdx - 1);
        }

        public AbstractItem getPrevStackItem() {
            return this.getPrevStackElement().getItem();
        }

        public int getPrevItemLevel() {
            return this.getPrevStackElement().getLevel();
        }

        @Override
        public boolean isEmpty() {
            return this.stackIdx < 0;
        }
    }

    static class LevelElement {
        private AbstractItem item;
        private int level;
        private String type;
        private AlignmentState alignmentState;

        public LevelElement(AbstractItem item, int level, AlignmentState alState) {
            this.item = item;
            this.level = level;
            this.alignmentState = alState;
        }

        public AbstractItem getItem() {
            return this.item;
        }

        public void setItem(AbstractItem item) {
            this.item = item;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public AlignmentState getAlignmentState() {
            return this.alignmentState;
        }

        public void setAlignmentState(AlignmentState alState) {
            this.alignmentState = alState;
        }
    }

    static enum AlignmentState {
        ALIGNED,
        UNALIGNED,
        DEFAULT;

    }
}

