/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccommons;

import de.ubs.jdbcserver.jdbccomm.Constants;
import de.ubs.jdbcserver.jdbccomm.RemoteSession;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccommons.FileInfo;
import de.ubs.jdbcserver.jdbccommons.RemoteFile;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;

public class RemoteFileSession
extends RemoteSession {
    protected RemoteFileSession(String server, int port, String user, String password) throws Exception {
        super(server, port, user, password, false);
    }

    protected RemoteFileSession(String server, int port, String user, String password, boolean encrypted) throws Exception {
        super(server, port, user, password, encrypted);
    }

    public static RemoteFileSession connect(String server, int port, String user, String password) throws Exception {
        return new RemoteFileSession(server, port, user, password);
    }

    public static RemoteFileSession connect(String server, int port, String user, String password, boolean encrypted) throws Exception {
        return new RemoteFileSession(server, port, user, password, encrypted);
    }

    public RemoteFile createFile(String path, String openMode) throws IOException {
        return new RemoteFile(this, path, openMode);
    }

    public RemoteFile createFile(String path, String openMode, TablespaceLayout descriptor) throws IOException {
        return new RemoteFile(this, path, openMode, descriptor);
    }

    public String executeIdcams(String command) throws Exception {
        Element element = new Element("file");
        element.setAttribute("action", Constants.FileAction.IDCAMS.name());
        element.setText(command);
        Element result = this.send(element);
        int rc = Integer.parseInt(result.getAttributeValue("rc"));
        if (rc == 0) {
            return result.getText();
        }
        throw new RuntimeException(result.getText());
    }

    public List<String> members(String dsn) throws Exception {
        Element element = new Element("list-files");
        element.setAttribute("dsn", dsn);
        element.setAttribute("pds", String.valueOf(true));
        LinkedList<String> outputList = new LinkedList<String>();
        Element result = this.send(new Document(element));
        if (result != null) {
            for (Element memberElement : result.getChildren()) {
                outputList.add(memberElement.getText());
            }
        }
        return outputList;
    }

    public List<FileInfo> search(String dsnPattern) throws Exception {
        Element element = new Element("list-files");
        element.setAttribute("dsn", dsnPattern);
        LinkedList<FileInfo> outputList = new LinkedList<FileInfo>();
        Element result = this.send(new Document(element));
        if (result != null) {
            for (Element children : result.getChildren()) {
                FileInfo info = new FileInfo(children.getText());
                for (Attribute attribute : children.getAttributes()) {
                    info.getAttributes().put(attribute.getName(), attribute.getValue());
                }
                outputList.add(info);
            }
        }
        return outputList;
    }
}

