/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccommons;

import de.ubs.jdbcserver.jdbccomm.Constants;
import de.ubs.jdbcserver.jdbccomm.RecordFormat;
import de.ubs.jdbcserver.jdbccomm.RemoteSession;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccomm.transport.Transportable;
import de.ubs.jdbcserver.jdbccomm.transport.TransportableFactory;
import de.ubs.jdbcserver.jdbccomm.util.ClientSerializer;
import de.ubs.jdbcserver.jdbccommons.FileType;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class RemoteFile
implements Closeable {
    private final String path;
    private final String openMode;
    private final RemoteSession session;
    private UUID fileID;
    private int recordBufferSize = 1;
    private TablespaceLayout descriptor;
    private TransportableFactory.TransportType transportType = TransportableFactory.TransportType.COMPRESS;
    private Transportable<ArrayList> transportable;
    private RecordFormat recordFormat = RecordFormat.RAW;
    private boolean eof = false;
    private List<byte[]> cachedRecords;
    private int currentCacheIndex = 0;

    RemoteFile(RemoteSession session, String path) throws IOException {
        this(session, path, "rb,type=record", null);
    }

    RemoteFile(RemoteSession session, String path, String openMode) throws IOException {
        this(session, path, openMode, null);
    }

    RemoteFile(RemoteSession session, String path, String openMode, TablespaceLayout descriptor) throws IOException {
        this.session = session;
        this.path = path;
        this.openMode = openMode;
        this.descriptor = descriptor;
        this.open();
    }

    public void setRecordFormat(RecordFormat recordFormat) {
        this.recordFormat = recordFormat;
    }

    public void setRecordBufferSize(int recordBufferSize) {
        this.recordBufferSize = recordBufferSize;
    }

    public TransportableFactory.TransportType getTransportType() {
        return this.transportType;
    }

    public void setTransportType(TransportableFactory.TransportType transportType) {
        this.transportType = transportType;
    }

    public void write(byte[] buf) throws IOException, Exception {
        Element element = new Element("file");
        element.setAttribute("action", Constants.FileAction.WRITE.name());
        element.setAttribute("file-id", this.fileID.toString());
        element.setAttribute("record-count", "1");
        ArrayList<byte[]> array = new ArrayList<byte[]>();
        array.add(buf);
        element.setText(this.transportable.serialize(array));
        this.session.send(element);
    }

    public final void open() throws IOException {
        Element element = new Element("file");
        element.setAttribute("action", Constants.FileAction.OPEN.name());
        element.setAttribute("path", this.path);
        element.setAttribute("mode", this.openMode);
        element.setAttribute("type", FileType.VSAM_KSDS.name());
        element.setAttribute("transportable", this.transportType.name());
        this.transportable = TransportableFactory.createTransportable(this.getTransportType(), ArrayList.class);
        if (this.descriptor != null) {
            element.addContent(ClientSerializer.toXML(this.descriptor));
            this.recordFormat = RecordFormat.OBJECTS;
        }
        try {
            Element result = this.session.send(new Document(element));
            String id = result.getAttributeValue("file-id");
            this.fileID = UUID.fromString(id);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public int read(byte[] buf, int offset, int length) throws Exception {
        byte[] readData = (byte[])this.readData();
        if (readData == null) {
            return -1;
        }
        int count = Math.min(readData.length, length);
        System.arraycopy(readData, 0, buf, offset, count);
        return count;
    }

    public int read(byte[] buf) throws Exception {
        return this.read(buf, 0, buf.length);
    }

    public Object[] readRecord() throws Exception {
        return (Object[])this.readData();
    }

    private Object readData() throws Exception {
        boolean cacheConsumed;
        boolean bl = cacheConsumed = this.cachedRecords != null && this.currentCacheIndex >= this.cachedRecords.size();
        if (this.eof && cacheConsumed) {
            return null;
        }
        if (this.cachedRecords == null || cacheConsumed) {
            Element element = new Element("file");
            element.setAttribute("action", Constants.FileAction.READ.name());
            element.setAttribute("file-id", this.fileID.toString());
            element.setAttribute("record-count", String.valueOf(this.recordBufferSize));
            element.setAttribute("record-format", this.recordFormat.name());
            Document document = new Document(element);
            Element result = this.session.send(document);
            this.eof = Boolean.parseBoolean(result.getAttributeValue("eof", "false"));
            if (this.eof && result.getText().isEmpty()) {
                return null;
            }
            this.cachedRecords = this.transportable.deserialize(result.getText());
            this.currentCacheIndex = 0;
        }
        byte[] obj = this.cachedRecords.get(this.currentCacheIndex);
        ++this.currentCacheIndex;
        return obj;
    }

    @Override
    public void close() throws IOException {
        if (this.fileID != null) {
            Element element = new Element("file");
            element.setAttribute("action", Constants.FileAction.CLOSE.name());
            element.setAttribute("file-id", this.fileID.toString());
            try {
                this.session.send(new Document(element));
            }
            catch (Exception ex) {
                Logger.getLogger(RemoteFile.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

