/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm.util;

import de.ubs.jdbcserver.jdbccomm.Constants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jdom2.Element;

public class CommonUtils {
    private static final String OS_NAME = "z/OS";

    public static boolean isZos() {
        return OS_NAME.equalsIgnoreCase(System.getProperty("os.name"));
    }

    public static String readUTF(DataInputStream in) throws IOException {
        byte[] data = CommonUtils.read(in);
        return new String(data, StandardCharsets.UTF_8);
    }

    public static byte[] read(DataInputStream in) throws IOException {
        int length = in.readInt();
        if (length < 0) {
            if (length == -720899) {
                throw new IOException("Connection closed by Telnet client");
            }
            throw new IOException("Incorrect protocol or synchronization error)");
        }
        byte[] data = new byte[length];
        in.readFully(data);
        return data;
    }

    public static void writeUTF(DataOutputStream out, byte[] dataInUTF8) throws IOException {
        out.writeInt(dataInUTF8.length);
        out.write(dataInUTF8);
    }

    public static void writeUTF(DataOutputStream out, String s) throws IOException {
        CommonUtils.writeUTF(out, s.getBytes(StandardCharsets.UTF_8));
    }

    public static Constants.Status getStatus(Element replyElement) {
        String status = replyElement.getAttributeValue("status");
        if (status.equals("ok")) {
            return Constants.Status.OK;
        }
        if (status.equals("exception")) {
            return Constants.Status.EXCEPTION;
        }
        if (status.equals("invalid")) {
            return Constants.Status.INVALID;
        }
        return Constants.Status.UNKNOWN;
    }
}

