/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm.struct;

import java.util.Arrays;
import java.util.stream.Collectors;

public class ItemPath {
    private String[] pathElements;

    public ItemPath(String ... pathElements) {
        this.pathElements = pathElements;
    }

    public ItemPath copyAndExchange(int pos, String newItem) {
        String[] newPath = new String[this.pathElements.length];
        System.arraycopy(this.pathElements, 0, newPath, 0, this.pathElements.length);
        newPath[pos] = newItem;
        return new ItemPath(newPath);
    }

    public int size() {
        return this.pathElements.length;
    }

    public ItemPath getParentPath() {
        if (this.pathElements.length <= 1) {
            return null;
        }
        String[] newPath = new String[this.pathElements.length - 1];
        System.arraycopy(this.pathElements, 0, newPath, 0, this.pathElements.length - 1);
        return new ItemPath(newPath);
    }

    public String toString() {
        return Arrays.stream(this.pathElements).collect(Collectors.joining("."));
    }

    public String[] getPathElements() {
        return this.pathElements;
    }

    public void setPathElements(String[] pathElements) {
        this.pathElements = pathElements;
    }

    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + Arrays.deepHashCode(this.pathElements);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemPath other = (ItemPath)obj;
        return Arrays.deepEquals(this.pathElements, other.pathElements);
    }
}

