/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.file;

import com.ibm.jzos.ZFile;
import de.ubs.jdbcserver.file.AbstractModifiableCsvFile;
import de.ubs.jdbcserver.file.CsvFileReader;
import de.ubs.jdbcserver.file.CsvFileWriter;
import de.ubs.jdbcserver.file.MainframeCsvFileReader;
import de.ubs.jdbcserver.file.MainframeCsvFileWriter;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class ModifiableMainframeCsvFile
extends AbstractModifiableCsvFile {
    private final ZFile zfile;

    public ModifiableMainframeCsvFile(ZFile f, TablespaceDefinition ts, TableDefinition tb) throws IOException {
        this(f, ts.getLayout().getDefaultStringEncoding(), ts.getCSVColumnDelimiter(), ts.getCSVStringDelimiter(), ts.getCSVQuoteMode(), ts.isReadOnly(), ts.getCSVCacheSize(), ts.isStrictEncoding(), ts.isCSVHeader(), ModifiableMainframeCsvFile.columnNamesToStringArray(tb.getColumns()));
    }

    ModifiableMainframeCsvFile(ZFile f, Charset encoding, char columnDelimiter, char stringDelimiter, TablespaceDefinition.CsvQuoteMode csvQuoteMode, boolean readOnly, int cacheSize, boolean strictEncoding, boolean withHeader, String[] colNames) throws IOException {
        super(encoding, columnDelimiter, stringDelimiter, csvQuoteMode, readOnly, cacheSize, strictEncoding, withHeader, colNames);
        this.zfile = f;
        this.in = this.createNewReader(false);
        this.readOnly = readOnly;
        this.filenameForMessages = this.zfile.getFilename();
    }

    @Override
    protected CsvFileReader createNewReader(boolean forFlush) throws IOException {
        CsvFileReader.HeaderProcessingMode headerProcessingMode = this.firstLineIsHeader ? (forFlush ? CsvFileReader.HeaderProcessingMode.READ_BUT_DO_NOT_COUNT : CsvFileReader.HeaderProcessingMode.SKIP_AND_DO_NOT_COUNT) : CsvFileReader.HeaderProcessingMode.READ_AND_COUNT;
        MainframeCsvFileReader r = new MainframeCsvFileReader(this.zfile, this.encoding, this.csvQuoteMode == TablespaceDefinition.CsvQuoteMode.NONE ? (char)'\u0000' : this.stringDelimiter, this.codingErrorAction, headerProcessingMode);
        this.lineSeparator = r.getDetectedLineSeparator();
        return r;
    }

    @Override
    protected CsvFileWriter createNewWriter() throws IOException {
        return new MainframeCsvFileWriter(this.zfile, this.zfile.getFilename(), this.encoding);
    }

    @Override
    protected void applyDelta() throws IOException, SQLException {
        if (this.closed) {
            throw new RuntimeException("Internal error: applyDelta() was called but file is closed");
        }
        if (this.deltaMap.isEmpty()) {
            return;
        }
        throw new UnsupportedEncodingException("Method ModifiableMainframeCsvFile.applyDelta() is not implemented yet");
    }

    @Override
    public String getName() {
        return this.zfile.getFilename();
    }
}

