/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.file;

import java.sql.SQLException;

public class MainframeSystemAbendCodes {
    public static String getQSAMErrorCodeText(int code) throws SQLException {
        switch (code) {
            case 4: {
                return "Read past end of file ";
            }
            case 8: {
                throw new SQLException("You attempted to store a record with a Duplicate Key, or there is a duplicate record for an alternate index with the unique key option. ", "23505", -803);
            }
            case 12: {
                return "You attempted to store a record out of Ascending Key Sequence in Skip-Sequential Mode; record had a Duplicate Key; for Skip-Sequential processing your GET, PUT, and POINT Requests are not referencing records in Ascending Sequence; or, for Skip-Sequential Retrieval, the key requested is lower than the previous key requested. For Shared Resources, buffer pool is full. ";
            }
            case 16: {
                return "Record not found. ";
            }
            case 20: {
                return "Record already held in exclusive control by another requester. ";
            }
            case 24: {
                return "Record resides on a volume that cannot be mounted. ";
            }
            case 28: {
                return "Data set cannot be extended because VSAM can't allocate additional Direct-Access Storage Space.  Either there is not enough space left to make the secondary allocation or you attempted to increase the size of a data set while processing SHROPT=4 and DISP=SHR. ";
            }
            case 36: {
                return "Key Ranges were specified for the data set when it was defined but no range was specified that includes the record to be inserted. ";
            }
            case 40: {
                return "Insufficient Virtual Storage to complete the request. ";
            }
            case 44: {
                return "Work area too small. ";
            }
            case 64: {
                return "All available strings are in use. ";
            }
            case 68: {
                return "You attempted to use a type of processing (Output or Control-Interval Processing) that was not specified when the data set was opened. ";
            }
            case 74: {
                return "Trying to use keys on ESDS or RRDS. ";
            }
            case 76: {
                return "You issued an Addressed or Control-Interval PUT to add to a Key-Sequenced data set, or issued a Control-Interval put to a Relative Record data set. ";
            }
            case 80: {
                return "Trying to delete from ESDS. ";
            }
            case 84: {
                return "Using OPTCODE=LOC for a PUT. ";
            }
            case 88: {
                return "You issued a Sequential GET request without having caused VSAM to be positioned for it, or you changed from Addressed Access to Keyed Access without causing VSAM to be positioned for Keyed- Sequential Retrieval; there was no Sequential PUT insert for a Relative Record data set, or you attempted an illegal switch between forward and backward processing. ";
            }
            case 92: {
                return "A PUT for update or an ERASE was issued without a previous GET for update, or a PUTIX was issued without a previous GETIX. ";
            }
            case 96: {
                return "Changing the Prime Key or Key of Reference when making an update. ";
            }
            case 100: {
                return "Trying to change record length. ";
            }
            case 104: {
                return "The RPL options are either invalid or conflicting. ";
            }
            case 108: {
                return "RECLEN specified was larger than the maximum allowed, equal to 0, or smaller than the sum of the length and the displacement of the key field; RECLEN was not equal to record (SLOT) size specified for a Relative Record data set. ";
            }
            case 112: {
                return "Invalid key length. ";
            }
            case 116: {
                return "Trying to update an empty dataset. ";
            }
            case 120: {
                return "Request was submitted by the wrong task. ";
            }
            case 132: {
                return "An attempt was made in Locate Mode to retrieve a Spanned Record. ";
            }
            case 136: {
                return "You attempted an Addressed GET of a Spanned record in a Key- Sequenced data set. ";
            }
            case 140: {
                return "Inconsistent Spanned record. ";
            }
            case 144: {
                return "Invalid pointer (no associated base record) in an Alternate Index. ";
            }
            case 148: {
                return "Maximum number of Alternate Index pointers exceeded. ";
            }
            case 152: {
                return "Not enough buffers available. ";
            }
            case 156: {
                return "Invalid control interval. ";
            }
            case 192: {
                return "Invalid Relative Record number in a RRDS dataset. ";
            }
            case 196: {
                return "Addressed access to a Relative Record (RRDS) dataset is not allowed. ";
            }
            case 200: {
                return "Addressed Access or Generic Backward processing by Key thru a path is not allowed. ";
            }
            case 204: {
                return "Attempting a PUT in backward mode. ";
            }
            case 252: {
                return "Record mode processing is not allowed for a Linear data set. VSAM Open error codes ";
            }
        }
        return null;
    }

    public static String getErrorCodeText(int code) throws SQLException {
        String msg = MainframeSystemAbendCodes.getQSAMErrorCodeText(code);
        if (msg != null) {
            return msg;
        }
        return MainframeSystemAbendCodes.getVSAMErrorCodeText(code);
    }

    public static String getVSAMErrorCodeText(int code) throws SQLException {
        switch (code) {
            case 136: {
                return "Not enough Virtual-Storage Space is available for Work Areas, Control Blocks, or Buffers. ";
            }
            case 144: {
                return "An uncorrectable I/O error occurred while VSAM was Reading or Writing a catalog record. ";
            }
            case 148: {
                return "No record for the data set to be opened was found in the available catalog(s) or an unidentified error occurred while VSAM was searching the catalog. ";
            }
            case 152: {
                return "Security Verification failed; the password specified in the Access-Method Control Block for a specified level of access does not match the password in the catalog for that level of access. ";
            }
            case 164: {
                return "An uncorrectable I/O error occurred while VSAM was Reading the Volume Label. ";
            }
            case 168: {
                return "The data set is not available for the type of processing you specify, or an attempt was made to open a Reusable data set with the Reset option while another user had the data set. ";
            }
            case 176: {
                return "An error occurred while VSAM was attempting to fix a page of Virtual storage in Real storage. ";
            }
            case 180: {
                return "A VSAM catalog specified in JCL either does not exist or is not open, and no record for the data set to be opened was found in any other catalog. ";
            }
            case 184: {
                return "An uncorrectable I/O error occurred while VSAM was completing an I/O request. ";
            }
            case 188: {
                return "The data set indicated by the Access-Method Control Block is not of the type that may be specified by an Access-Method Control Block. ";
            }
            case 192: {
                return "An unusable data set was opened for output. ";
            }
            case 232: {
                return "Reset was specified for a nonreusable data set and the data set is not empty. ";
            }
            case 236: {
                return "A permanent Staging error occurred in MSS (Acquire). ";
            }
        }
        return null;
    }
}

