/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.file;

import com.ibm.jzos.RecordReader;
import com.ibm.jzos.ZFile;
import de.ubs.jdbcserver.file.AbstractCsvFileReader;
import de.ubs.jdbcserver.file.CsvFileReader;
import de.ubs.jdbcserver.file.MainframeCsvFileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MainframeCsvFileReader
extends AbstractCsvFileReader {
    private final Charset encoding;
    private final char stringDelimiter;
    long recordsRead = 0L;
    private ZFile f;
    private byte[] buf;
    private RecordReader rr;

    public MainframeCsvFileReader(ZFile f, Charset encoding, char stringDelimiter, CodingErrorAction codingErrorAction, CsvFileReader.HeaderProcessingMode headerProcessingMode) throws IOException {
        super(encoding, codingErrorAction, stringDelimiter, headerProcessingMode);
        Logger.getLogger(MainframeCsvFileReader.class.getName()).log(Level.FINE, String.format("Creating MainframeCsvFileReader for %s", f.getFilename()));
        this.f = f;
        this.encoding = encoding;
        this.stringDelimiter = stringDelimiter;
        this.buf = new byte[f.getLrecl()];
        this.rr = RecordReader.newReader(f.getFilename(), 1);
    }

    @Override
    public String getNextRawRecord() throws IOException {
        String ret;
        Logger.getLogger(MainframeCsvFileWriter.class.getName()).log(Level.FINE, String.format("MainframeCsvFileReader.readRecord() called", new Object[0]));
        StringBuilder sb = new StringBuilder();
        int delims = 0;
        while (true) {
            int rc;
            if ((rc = this.rr.read(this.buf)) == -1) {
                if (sb.toString().isEmpty()) {
                    return null;
                }
                ret = sb.toString();
                break;
            }
            ++this.recordsRead;
            String s = new String(this.buf, 0, rc, this.encoding);
            sb.append(s);
            if (this.stringDelimiter != '\u0000') {
                delims += StringUtils.countMatches((CharSequence)s, Character.toString(this.stringDelimiter));
            }
            if (delims % 2 == 0) {
                ret = sb.toString();
                break;
            }
            sb.append('\n');
        }
        return StringUtils.stripEnd(ret, " \n\r\t");
    }

    @Override
    public void close() throws IOException {
        this.rr.close();
    }

    @Override
    public long getRecordNumber() {
        return this.recordsRead;
    }

    @Override
    public String getDetectedLineSeparator() {
        return "";
    }
}

