/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.file;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import de.ubs.jdbcserver.file.AbstractProcessableFile;
import de.ubs.jdbcserver.file.EmulatedMainframeFile;
import de.ubs.jdbcserver.file.GenericFile;
import de.ubs.jdbcserver.file.MainframeFile;
import de.ubs.jdbcserver.file.ModifiableMainframeCsvFile;
import de.ubs.jdbcserver.file.ModifiableUnixCsvFile;
import de.ubs.jdbcserver.file.ProcessableFile;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.util.CommonUtils;
import de.ubs.jdbcserver.jdbccommons.FileType;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileManager {
    private static FileManager instance;
    private final Map<UUID, ProcessableFile> fileMap = new HashMap<UUID, ProcessableFile>();

    public static synchronized FileManager getDefault() {
        if (instance == null) {
            instance = new FileManager();
        }
        return instance;
    }

    public synchronized ProcessableFile open(String path, String mode, FileType type, TablespaceDefinition tablespaceDefinition, TableDefinition tableDefinition) throws IOException, SQLException {
        AbstractProcessableFile rc = null;
        if (!CommonUtils.isZos()) {
            File f = Paths.get(path, new String[0]).isAbsolute() ? new File(path) : Paths.get(System.getProperty("user.dir"), path).toFile();
            Logger.getLogger(FileManager.class.getName()).log(Level.FINE, String.format("Opening file %s with mode %s for tablespace %s", f.getAbsolutePath(), mode, tablespaceDefinition.getName()));
            switch (type) {
                case SEQUENTIAL: {
                    rc = new GenericFile(f);
                    break;
                }
                case PLAINTEXT_CSV: {
                    if (tablespaceDefinition != null && tableDefinition != null && tablespaceDefinition.getTablespaceType() == TablespaceDefinition.TablespaceType.CSV) {
                        try {
                            rc = new ModifiableUnixCsvFile(f, tablespaceDefinition, tableDefinition);
                            break;
                        }
                        catch (IOException ex) {
                            throw new SQLException(ex);
                        }
                    }
                    throw new RuntimeException("Cannot open CSV file - tablespace or table definition not specified in open() method");
                }
                case VSAM_KSDS: {
                    rc = new EmulatedMainframeFile(path, mode, type, false);
                }
            }
        } else {
            switch (type) {
                case VSAM_KSDS: 
                case VSAM_ESDS: 
                case VSAM_RRDS: {
                    rc = new MainframeFile(path, mode, type, tablespaceDefinition == null ? false : tablespaceDefinition.isReadOnly());
                    break;
                }
                case PLAINTEXT_CSV: {
                    if (path.startsWith("/") && !path.startsWith("//'")) {
                        File f = new File(path);
                        if (tablespaceDefinition == null || tableDefinition == null || tablespaceDefinition.getTablespaceType() != TablespaceDefinition.TablespaceType.CSV) {
                            throw new RuntimeException("Cannot open CSV file - tablespace or table definition not specified in open() method");
                        }
                        try {
                            Logger.getLogger(FileManager.class.getName()).log(Level.FINE, String.format("Opening USS file %s with mode %s for tablespace %s", f.getAbsolutePath(), mode, tablespaceDefinition.getName()));
                            rc = new ModifiableUnixCsvFile(f, tablespaceDefinition, tableDefinition);
                            break;
                        }
                        catch (IOException ex) {
                            throw new SQLException(ex);
                        }
                    }
                    ZFile z = new ZFile(ZFile.getSlashSlashQuotedDSN(path, true), "rb,type=record");
                    if (tablespaceDefinition == null || tableDefinition == null || tablespaceDefinition.getTablespaceType() != TablespaceDefinition.TablespaceType.CSV) {
                        throw new RuntimeException("Cannot open CSV file - tablespace or table definition not specified in open() method");
                    }
                    try {
                        Logger.getLogger(FileManager.class.getName()).log(Level.FINE, String.format("Opening data set %s with mode %s for tablespace %s", z.getFilename(), mode, tablespaceDefinition.getName()));
                        rc = new ModifiableMainframeCsvFile(z, tablespaceDefinition, tableDefinition);
                        break;
                    }
                    catch (IOException ex) {
                        throw new SQLException(ex);
                    }
                }
                default: {
                    throw new RuntimeException("File type " + (Object)((Object)type) + " is not supported yet");
                }
            }
        }
        if (rc != null) {
            this.fileMap.put(rc.getUUID(), rc);
        }
        Logger.getLogger(FileManager.class.getName()).log(Level.FINE, String.format("File handle for %s has UUID %s", path, rc.getUUID().toString()));
        return rc;
    }

    public synchronized ProcessableFile close(UUID uuid) {
        Logger.getLogger(FileManager.class.getName()).log(Level.FINE, String.format("Closing file with UUID %s", uuid.toString()));
        ProcessableFile file = this.fileMap.get(uuid);
        if (file != null) {
            file.close();
        }
        return file;
    }

    public synchronized ProcessableFile get(UUID uuid) {
        return this.fileMap.get(uuid);
    }

    public synchronized void deleteFile(String path) throws IOException {
        if (!CommonUtils.isZos()) {
            File f = Paths.get(path, new String[0]).isAbsolute() ? new File(path) : Paths.get(System.getProperty("user.dir"), path).toFile();
            Logger.getLogger(FileManager.class.getName()).log(Level.INFO, "Deleting file {0}", f.getAbsolutePath());
            if (Files.exists(f.toPath(), new LinkOption[0])) {
                Files.delete(f.toPath());
            }
        } else if (path.startsWith("/") && !path.startsWith("//'")) {
            File f = new File(path);
            Logger.getLogger(FileManager.class.getName()).log(Level.INFO, "Deleting file {0}", f.getAbsolutePath());
            Files.delete(f.toPath());
        } else {
            String fullyQualifiedDsn = ZFile.getSlashSlashQuotedDSN(path, true);
            Logger.getLogger(FileManager.class.getName()).log(Level.INFO, "Deleting data set {0}", fullyQualifiedDsn);
            try {
                ZFile.remove(fullyQualifiedDsn);
            }
            catch (ZFileException ex) {
                throw new IOException(ex);
            }
        }
    }
}

