/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.file;

import com.ibm.jzos.ZFileException;
import de.ubs.jdbcserver.file.AbstractProcessableFile;
import de.ubs.jdbcserver.jdbccommons.FileType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmulatedMainframeFile
extends AbstractProcessableFile {
    private static final String KEY_POSITION = "AMDKEY";
    private static final String ENTRY_TYPE = "ENTYPE";
    private static final char INDEX_ENTRY_TYPE = 'I';
    private static final int CATALOG_ERROR = 100;
    private final String path;
    private final FileType type;
    private final File file;
    private final boolean readOnly;
    private int keyLength = -1;
    private int keyPosition = -1;
    private DataOutputStream dataOutputStream;
    private DataInputStream dataInputStream;

    public EmulatedMainframeFile(String path, String mode, FileType type, boolean readOnly) throws ZFileException, SQLException {
        this.path = path;
        this.type = type;
        this.readOnly = readOnly;
        try {
            this.file = new File(path);
            Logger.getLogger(EmulatedMainframeFile.class.getName()).log(Level.FINE, "VSAM index key length {0}", 0);
        }
        catch (Exception ex) {
            throw new SQLException(String.format("Allocation failed. %s", ex.getMessage()), "57011", -904);
        }
        this.determineKeyInformation();
    }

    @Override
    public boolean isVariableLength() {
        return true;
    }

    @Override
    public int getRecordCount() {
        return 0;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public int getKeyStartOffset() {
        return this.keyPosition;
    }

    @Override
    public int getKeyLength() {
        return this.keyLength;
    }

    @Override
    public void begin() throws IOException {
    }

    @Override
    public void deleteLastReadRecord() throws IOException, SQLException {
    }

    private void determineKeyInformation() throws ZFileException {
    }

    @Override
    public String getName() {
        return this.path;
    }

    @Override
    public void close() {
        try {
            if (this.dataInputStream != null) {
                this.dataInputStream.close();
            }
            if (this.dataOutputStream != null) {
                this.dataOutputStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateRecord(byte[] data, int length) throws IOException, SQLException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void writeRecord(byte[] data, int length) throws IOException, SQLException {
        DataOutputStream dos = this.getOutputStream();
        dos.writeInt(length);
        dos.write(data, 0, length);
    }

    private DataOutputStream getOutputStream() {
        if (this.dataOutputStream == null) {
            try {
                this.dataOutputStream = new DataOutputStream(new FileOutputStream(this.file));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.dataOutputStream;
    }

    private DataInputStream getInputStream() {
        if (this.dataInputStream == null) {
            try {
                this.dataInputStream = new DataInputStream(new FileInputStream(this.file));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.dataInputStream;
    }

    @Override
    public int readRecord(byte[] data) throws IOException, BufferOverflowException, SQLException {
        DataInputStream inputStream = this.getInputStream();
        try {
            int length = inputStream.readInt();
            inputStream.read(data, 0, length);
            return length;
        }
        catch (EOFException eofException) {
            return -1;
        }
    }

    @Override
    public int getMaximumRecordLength() {
        return 32768;
    }

    @Override
    public boolean locate(byte[] data) throws IOException, BufferOverflowException, SQLException {
        throw new RuntimeException("Not implemented");
    }
}

