/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.evaluation;

import de.ubs.jdbcserver.evaluation.AbstractParameterMarkerVisitor;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;

public class UpdateParameterMarkerVisitor
extends AbstractParameterMarkerVisitor {
    private String nextParameterColumnName = null;

    public UpdateParameterMarkerVisitor(TableDefinition tableDefinition) {
        super(tableDefinition);
    }

    @Override
    public Object visitUpdateSpec(SQLParserParser.UpdateSpecContext ctx) {
        this.nextParameterColumnName = ctx.identifier().value;
        return super.visitUpdateSpec(ctx);
    }

    @Override
    public Object visitParameterMarker(SQLParserParser.ParameterMarkerContext ctx) {
        if (this.nextParameterColumnName != null) {
            this.addParameterMetaData(this.getColumnReference(this.nextParameterColumnName));
            this.nextParameterColumnName = null;
        }
        return super.visitParameterMarker(ctx);
    }

    @Override
    public Object visitEquation(SQLParserParser.EquationContext ctx) {
        ColumnDefinition columnReference = this.getColumnReference(ctx.sum(0));
        if (columnReference != null) {
            this.nextParameterColumnName = columnReference.getName();
        }
        return super.visitEquation(ctx);
    }
}

