/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.evaluation;

import de.ubs.jdbcserver.command.sql.ParameterValueData;
import de.ubs.jdbcserver.evaluation.EvaluationVisitor;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import java.sql.SQLException;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;

public class ExpressionEvaluator<T> {
    private final EvaluationVisitor visitor;

    public ExpressionEvaluator(TableDefinition table) throws SQLException {
        this(table, null, null);
    }

    public ExpressionEvaluator(TableDefinition table, ParameterValueData parameterMarkerContents, ParserRuleContext tree) throws SQLException {
        this.visitor = new EvaluationVisitor(table, parameterMarkerContents, tree);
    }

    public EvaluationVisitor getVisitor() {
        return this.visitor;
    }

    public void setValue(String columnName, Comparable value) {
        this.visitor.setValue(columnName, value);
    }

    public Map<String, Integer> getReferencedWhereColumns() {
        return this.visitor.getReferencedWhereColumns();
    }

    public T evaluate(ParserRuleContext tree) throws SQLException {
        if (tree == null) {
            return null;
        }
        try {
            return (T)tree.accept(this.visitor);
        }
        catch (EvaluationVisitor.UncheckedSQLException ex) {
            throw new SQLException(ex.getMessage(), ex.getState(), ex.getVendorCode(), ex);
        }
    }

    public T evaluate() throws SQLException {
        return this.evaluate(this.visitor.getTree());
    }
}

