/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.evaluation;

import de.ubs.jdbcserver.command.sql.StatementCommand;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserBaseVisitor;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ColumnDefinitionVisitor
extends SQLParserBaseVisitor<ColumnDefinition> {
    private static final BigDecimal BD_SHORT_MIN = new BigDecimal(Short.MIN_VALUE);
    private static final BigDecimal BD_SHORT_MAX = new BigDecimal(Short.MAX_VALUE);
    private static final BigDecimal BD_INT_MIN = new BigDecimal(Integer.MIN_VALUE);
    private static final BigDecimal BD_INT_MAX = new BigDecimal(Integer.MAX_VALUE);
    private static final BigDecimal BD_LONG_MIN = new BigDecimal(Long.MIN_VALUE);
    private static final BigDecimal BD_LONG_MAX = new BigDecimal(Long.MAX_VALUE);
    private final TableDefinition td;
    private final String columnName;
    private SQLException ex = null;

    public ColumnDefinitionVisitor(TableDefinition td, String columnName) {
        this.td = td;
        this.columnName = columnName;
    }

    public static boolean isWholeIntegerDatatype(int type) {
        switch (type) {
            case -5: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumericDatatype(int type) {
        switch (type) {
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStringDatatype(int type) {
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBinaryDatatype(int type) {
        switch (type) {
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    public static ColumnDefinition getColumnDefinition(BigDecimal num, String columnName) {
        ColumnDefinition cd = new ColumnDefinition(columnName, new String[0]);
        if (num.abs().equals(num)) {
            if (num.compareTo(BD_SHORT_MIN) >= 0 && num.compareTo(BD_SHORT_MAX) <= 0) {
                cd.setType(5);
                cd.setLength(2);
                cd.setScale(0);
            } else if (num.compareTo(BD_INT_MIN) >= 0 && num.compareTo(BD_INT_MAX) <= 0) {
                cd.setType(4);
                cd.setLength(4);
                cd.setScale(0);
            } else if (num.compareTo(BD_LONG_MIN) >= 0 && num.compareTo(BD_LONG_MAX) <= 0) {
                cd.setType(-5);
                cd.setLength(8);
                cd.setScale(0);
            }
        } else {
            cd.setType(3);
            cd.setLength(num.precision());
            cd.setScale(num.scale());
        }
        return cd;
    }

    public static ColumnDefinition getColumnDefinition(String s, String columnName) {
        ColumnDefinition cd = new ColumnDefinition(columnName, new String[0]);
        cd.setType(12);
        if (s == null) {
            cd.setLength(1);
            cd.setNullable(true);
        } else {
            cd.setLength(s.length());
            cd.setNullable(false);
        }
        cd.setScale(0);
        return cd;
    }

    private void setException(SQLException ex) {
        if (this.ex == null) {
            this.ex = ex;
        }
    }

    public ColumnDefinition getColumnDefinitionFor(SQLParserParser.ColRefContext colRef) throws SQLException {
        this.ex = null;
        ColumnDefinition ret = this.visitSum(colRef.sum());
        if (this.ex != null) {
            throw this.ex;
        }
        return ret;
    }

    public int getWidestDataType(int t1, int t2) {
        if (ColumnDefinitionVisitor.isNumericDatatype(t1) && ColumnDefinitionVisitor.isNumericDatatype(t2)) {
            if (t1 == 8 || t2 == 8) {
                return 8;
            }
            if (t1 == 6 || t2 == 6 || t1 == 7 || t2 == 7) {
                return 6;
            }
            if (t1 == 3 || t2 == 3) {
                return 3;
            }
            if (t1 == -5 || t2 == -5) {
                return -5;
            }
            if (t1 == 4 || t2 == 4) {
                return 4;
            }
            if (t1 == 5 || t2 == 5) {
                return 5;
            }
        } else if (ColumnDefinitionVisitor.isStringDatatype(t1) && ColumnDefinitionVisitor.isStringDatatype(t2)) {
            if (t1 == 1 || t2 == 1) {
                return 1;
            }
            return 12;
        }
        this.setException(new SQLException("The data type " + t1 + " is not compatible with " + t2, "42815", -171));
        return 0;
    }

    public boolean isTypeCompatible(int t1, int t2) {
        if (t1 == t2) {
            return true;
        }
        if (ColumnDefinitionVisitor.isNumericDatatype(t1) && ColumnDefinitionVisitor.isNumericDatatype(t2)) {
            return true;
        }
        return ColumnDefinitionVisitor.isStringDatatype(t1) && ColumnDefinitionVisitor.isStringDatatype(t2);
    }

    @Override
    public ColumnDefinition visitSum(SQLParserParser.SumContext ctx) {
        if (ctx.product() == null) {
            ColumnDefinition cd = this.visitSum(ctx.sum());
            if (!ColumnDefinitionVisitor.isNumericDatatype(cd.getType())) {
                this.setException(new SQLException("An operand of an arithmetic operation or an operand of a function that requires a number is not a number.", "42819", -402));
            }
            return cd;
        }
        ColumnDefinition cdLeft = this.visitProduct(ctx.product());
        if (ctx.sum() == null) {
            return cdLeft;
        }
        ColumnDefinition cdRight = this.visitSum(ctx.sum());
        if (ColumnDefinitionVisitor.isNumericDatatype(cdLeft.getType()) && ColumnDefinitionVisitor.isNumericDatatype(cdRight.getType())) {
            cdLeft.setType(this.getWidestDataType(cdLeft.getType(), cdRight.getType()));
        } else {
            this.setException(new SQLException("An operand of an arithmetic operation or an operand of a function that requires a number is not a number.", "42819", -402));
        }
        return cdLeft;
    }

    @Override
    public ColumnDefinition visitProduct(SQLParserParser.ProductContext ctx) {
        ColumnDefinition cdLeft = this.visitAtom(ctx.atom());
        if (ctx.product() == null) {
            return cdLeft;
        }
        ColumnDefinition cdRight = this.visitProduct(ctx.product());
        if (ColumnDefinitionVisitor.isNumericDatatype(cdLeft.getType()) && ColumnDefinitionVisitor.isNumericDatatype(cdRight.getType())) {
            cdLeft.setType(this.getWidestDataType(cdLeft.getType(), cdRight.getType()));
        } else {
            this.setException(new SQLException("The character value for the CAST, DECIMAL, FLOAT, or INTEGER scalar function is invalid.", "22018", -420));
        }
        return cdLeft;
    }

    @Override
    public ColumnDefinition visitAtom(SQLParserParser.AtomContext ctx) {
        if (ctx.sum() != null) {
            return this.visitSum(ctx.sum());
        }
        if (ctx.parameterMarker() != null) {
            this.setException(new SQLException("A parameter marker is not allowed.", "42610", -418));
            return new ColumnDefinition(this.columnName);
        }
        if (ctx.column() != null) {
            return this.visitColumn(ctx.column());
        }
        if (ctx.constant() != null) {
            return this.visitConstant(ctx.constant());
        }
        if (ctx.caseStatement() != null) {
            return this.visitCaseStatement(ctx.caseStatement());
        }
        if (ctx.columnFunction() != null) {
            return this.visitColumnFunction(ctx.columnFunction());
        }
        throw new RuntimeException("Internal error");
    }

    @Override
    public ColumnDefinition visitColumn(SQLParserParser.ColumnContext ctx) {
        ColumnDefinition columnDefinition = this.td.getColumnDefinition(ctx.identifier().value);
        if (columnDefinition == null) {
            SQLException e = new SQLException(String.format("The table %s.%s does not have a column called %s", this.td.getSchema(), this.td.getName(), ctx.identifier().value), "42703", -206);
            Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
        return columnDefinition.deepCopy();
    }

    @Override
    public ColumnDefinition visitConstant(SQLParserParser.ConstantContext ctx) {
        if (ctx.StringLiteral() != null) {
            String val = ctx.StringLiteral().getText();
            return ColumnDefinitionVisitor.getColumnDefinition(val, this.columnName);
        }
        if (ctx.HexLiteral() != null) {
            String val = ctx.HexLiteral().getText();
            return ColumnDefinitionVisitor.getColumnDefinition(val, this.columnName);
        }
        if (ctx.number() != null) {
            BigDecimal val = new BigDecimal(ctx.number().getText());
            return ColumnDefinitionVisitor.getColumnDefinition(val, this.columnName);
        }
        if (ctx.NULL() != null) {
            ColumnDefinition cd = new ColumnDefinition(this.columnName, new String[0]);
            cd.setType(1);
            return cd;
        }
        throw new RuntimeException("Internal error");
    }

    @Override
    public ColumnDefinition visitCaseStatement(SQLParserParser.CaseStatementContext ctx) {
        if (ctx.simpleCaseStatement() != null) {
            return this.visitSimpleCaseStatement(ctx.simpleCaseStatement());
        }
        if (ctx.complexCaseStatement() != null) {
            return this.visitComplexCaseStatement(ctx.complexCaseStatement());
        }
        throw new RuntimeException("Internal error");
    }

    @Override
    public ColumnDefinition visitSimpleCaseStatement(SQLParserParser.SimpleCaseStatementContext ctx) {
        ColumnDefinition firstCd = null;
        for (int i = 0; i < ctx.sum().size(); i += 2) {
            SQLParserParser.SumContext thenSum = ctx.sum(i + 1);
            if (i == 0) {
                firstCd = this.visitSum(thenSum);
                continue;
            }
            ColumnDefinition nextCd = this.visitSum(thenSum);
            if (this.isTypeCompatible(firstCd.getType(), nextCd.getType())) {
                firstCd.setType(this.getWidestDataType(firstCd.getType(), nextCd.getType()));
                continue;
            }
            this.setException(new SQLException("The result expressions in a CASE expression are not compatible.", "42804", -581));
            return firstCd;
        }
        if (ctx.elseClause() != null) {
            ColumnDefinition nextCd = this.visitSum(ctx.elseClause().sum());
            if (this.isTypeCompatible(firstCd.getType(), nextCd.getType())) {
                firstCd.setType(this.getWidestDataType(firstCd.getType(), nextCd.getType()));
            } else {
                this.setException(new SQLException("The result expressions in a CASE expression are not compatible.", "42804", -581));
                return firstCd;
            }
        }
        return firstCd;
    }

    @Override
    public ColumnDefinition visitComplexCaseStatement(SQLParserParser.ComplexCaseStatementContext ctx) {
        ColumnDefinition firstCd = null;
        for (int i = 0; i < ctx.sum().size(); ++i) {
            SQLParserParser.SumContext thenSum = ctx.sum(i);
            if (i == 0) {
                firstCd = this.visitSum(thenSum);
                continue;
            }
            ColumnDefinition nextCd = this.visitSum(thenSum);
            if (this.isTypeCompatible(firstCd.getType(), nextCd.getType())) {
                firstCd.setType(this.getWidestDataType(firstCd.getType(), nextCd.getType()));
                continue;
            }
            this.setException(new SQLException("The result expressions in a CASE expression are not compatible.", "42804", -581));
            return firstCd;
        }
        if (ctx.elseClause() != null) {
            ColumnDefinition nextCd = this.visitSum(ctx.elseClause().sum());
            if (this.isTypeCompatible(firstCd.getType(), nextCd.getType())) {
                firstCd.setType(this.getWidestDataType(firstCd.getType(), nextCd.getType()));
            } else {
                this.setException(new SQLException("The result expressions in a CASE expression are not compatible.", "42804", -581));
                return firstCd;
            }
        }
        return firstCd;
    }

    @Override
    public ColumnDefinition visitColumnFunction(SQLParserParser.ColumnFunctionContext ctx) {
        if (ctx.HEX() != null) {
            ColumnDefinition cd = new ColumnDefinition(this.columnName, new String[0]);
            cd.setType(12);
            ColumnDefinition originalCd = (ColumnDefinition)this.visitColRef(ctx.colRef(0));
            cd.setLength(originalCd.getLength() * 2);
            return cd;
        }
        if (ctx.LENGTH() != null) {
            ColumnDefinition cd = new ColumnDefinition(this.columnName, new String[0]);
            cd.setType(5);
            cd.setLength(2);
            return cd;
        }
        if (ctx.MAX() != null || ctx.MIN() != null) {
            ColumnDefinition cdLeft = (ColumnDefinition)this.visitColRef(ctx.colRef(0));
            ColumnDefinition cdRight = (ColumnDefinition)this.visitColRef(ctx.colRef(1));
            if (this.isTypeCompatible(cdLeft.getType(), cdRight.getType())) {
                cdLeft.setType(this.getWidestDataType(cdLeft.getType(), cdRight.getType()));
                return cdLeft;
            }
            this.setException(new SQLException("The operands of an arithmethic or compare operation are not compatible", "42818", -401));
            return null;
        }
        if (ctx.SUBSTR() != null) {
            ColumnDefinition originalCd = (ColumnDefinition)this.visitColRef(ctx.colRef(0));
            if (ColumnDefinitionVisitor.isStringDatatype(originalCd.getType())) {
                ColumnDefinition cdLength;
                ColumnDefinition cdStartPos = this.visitSum(ctx.sum(0));
                if (!ColumnDefinitionVisitor.isWholeIntegerDatatype(cdStartPos.getType())) {
                    this.setException(new SQLException("An operand of an arithmetic operation or an operand of a function that requires a number is not a number.", "42819", -402));
                    return originalCd;
                }
                if (ctx.sum().size() == 2 && !ColumnDefinitionVisitor.isWholeIntegerDatatype((cdLength = this.visitSum(ctx.sum(1))).getType())) {
                    this.setException(new SQLException("An operand of an arithmetic operation or an operand of a function that requires a number is not a number.", "42819", -402));
                    return originalCd;
                }
                return originalCd;
            }
            this.setException(new SQLException("The data type, length, or value of argument 1 of SUBSTR is invalid", "42815", -171));
            return null;
        }
        if (ctx.TO_CHAR() != null) {
            ColumnDefinition cd = new ColumnDefinition(this.columnName, new String[0]);
            cd.setType(12);
            ColumnDefinition originalCd = (ColumnDefinition)this.visitColRef(ctx.colRef(0));
            cd.setLength(Math.max(originalCd.getLength(), 128));
            cd.setNullable(true);
            return cd;
        }
        if (ctx.STRIP() != null) {
            ColumnDefinition cd = new ColumnDefinition(this.columnName, new String[0]);
            cd.setType(12);
            ColumnDefinition originalCd = (ColumnDefinition)this.visitColRef(ctx.colRef(0));
            cd.setLength(originalCd.getLength());
            cd.setNullable(originalCd.isNullable());
            return cd;
        }
        if (ctx.CONCAT() != null) {
            ColumnDefinition cd = new ColumnDefinition(this.columnName, new String[0]);
            cd.setType(12);
            ColumnDefinition originalCd1 = (ColumnDefinition)this.visitColRef(ctx.colRef(0));
            ColumnDefinition originalCd2 = (ColumnDefinition)this.visitColRef(ctx.colRef(1));
            cd.setLength(originalCd1.getLength() + originalCd2.getLength());
            cd.setNullable(originalCd1.isNullable() || originalCd2.isNullable());
            return cd;
        }
        if (ctx.UPPER() != null) {
            ColumnDefinition cd = new ColumnDefinition(this.columnName, new String[0]);
            cd.setType(12);
            ColumnDefinition originalCd = (ColumnDefinition)this.visitColRef(ctx.colRef(0));
            cd.setLength(originalCd.getLength());
            cd.setNullable(originalCd.isNullable());
            return cd;
        }
        if (ctx.LOWER() != null) {
            ColumnDefinition cd = new ColumnDefinition(this.columnName, new String[0]);
            cd.setType(12);
            ColumnDefinition originalCd = (ColumnDefinition)this.visitColRef(ctx.colRef(0));
            cd.setLength(originalCd.getLength());
            cd.setNullable(originalCd.isNullable());
            return cd;
        }
        if (ctx.TO_DATE() != null) {
            ColumnDefinition cd = new ColumnDefinition(this.columnName, new String[0]);
            cd.setType(91);
            cd.setLength(10);
            cd.setNullable(true);
            return cd;
        }
        if (ctx.TO_TIME() != null) {
            ColumnDefinition cd = new ColumnDefinition(this.columnName, new String[0]);
            cd.setType(92);
            cd.setLength(8);
            cd.setNullable(true);
            return cd;
        }
        if (ctx.TO_TIMESTAMP() != null) {
            ColumnDefinition cd = new ColumnDefinition(this.columnName, new String[0]);
            cd.setType(93);
            cd.setLength(26);
            cd.setNullable(true);
            return cd;
        }
        if (ctx.GETVARIABLE() != null) {
            ColumnDefinition cd = new ColumnDefinition(this.columnName, new String[0]);
            cd.setType(12);
            cd.setLength(255);
            cd.setNullable(true);
            return cd;
        }
        throw new RuntimeException("Internal error");
    }
}

