/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.evaluation;

import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserBaseVisitor;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractParameterMarkerVisitor
extends SQLParserBaseVisitor<Object> {
    protected final TableDefinition tableDefinition;
    private final List<ColumnDefinition> columnParameterMarker = new LinkedList<ColumnDefinition>();
    protected Integer nextParameterMarkerType = null;

    public AbstractParameterMarkerVisitor(TableDefinition tableDefinition) {
        this.tableDefinition = tableDefinition;
    }

    protected void addParameterMetaData(ColumnDefinition columnDefinition) {
        ColumnDefinition parameterColumn = columnDefinition.deepCopy();
        if (this.nextParameterMarkerType != null) {
            parameterColumn.setType(this.nextParameterMarkerType);
            this.nextParameterMarkerType = null;
        }
        this.columnParameterMarker.add(parameterColumn);
    }

    public List<ColumnDefinition> getParameterMarkerColumns() {
        return this.columnParameterMarker;
    }

    protected ColumnDefinition getColumnReference(SQLParserParser.SumContext ctx) {
        try {
            return this.getColumnReference(ctx.product().atom().column().identifier().value);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Override
    public Object visitColumnFunction(SQLParserParser.ColumnFunctionContext ctx) {
        if (ctx.TO_DATE() != null || ctx.TO_TIME() != null || ctx.TO_TIMESTAMP() != null) {
            this.nextParameterMarkerType = 12;
        }
        if (ctx.TO_CHAR() != null) {
            this.nextParameterMarkerType = 93;
        }
        return super.visitColumnFunction(ctx);
    }

    protected ColumnDefinition getColumnReference(String columnName) {
        try {
            return this.tableDefinition.getColumns().stream().filter(c -> c.getName().equals(columnName)).findFirst().get();
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    protected boolean isParameterMarker(SQLParserParser.SumContext ctx) {
        return ctx != null && ctx.product() != null && ctx.product().atom() != null && ctx.product().atom().parameterMarker() != null;
    }
}

