/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.cursor;

import de.ubs.jdbcserver.cursor.RecordInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FixedRecordInputStream
implements RecordInputStream {
    private InputStream is = null;

    public FixedRecordInputStream(InputStream stream) {
        this.is = new BufferedInputStream(stream);
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public int readRecord(byte[] bytes) throws IOException {
        int bytesToRead = bytes.length;
        int offset = 0;
        int c = this.is.read();
        if (c == -1) {
            return -1;
        }
        bytes[offset++] = (byte)c;
        --bytesToRead;
        while (bytesToRead > 0) {
            int bytesRead = this.is.read(bytes, offset, bytesToRead);
            if (bytesRead == -1) {
                throw new IOException("EOF encountered before all record bytes read");
            }
            bytesToRead -= bytesRead;
            offset += bytesRead;
        }
        return bytes.length;
    }
}

