/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.cursor;

import com.ibm.jzos.ZFileException;
import de.ubs.jdbcserver.builder.CSVRecordBuilder;
import de.ubs.jdbcserver.builder.RecordBuilder;
import de.ubs.jdbcserver.builder.SimpleRecordBuilder;
import de.ubs.jdbcserver.cursor.AbstractCursor;
import de.ubs.jdbcserver.evaluation.ExpressionEvaluator;
import de.ubs.jdbcserver.file.FileManager;
import de.ubs.jdbcserver.file.ProcessableFile;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import de.ubs.jdbcserver.splitter.CSVRecordSplitter;
import de.ubs.jdbcserver.splitter.RecordSplitter;
import de.ubs.jdbcserver.splitter.SimpleRecordSplitter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Hex;

public class FileCursor
extends AbstractCursor {
    protected final TablespaceDefinition tablespaceDefinition;
    protected final TablespaceLayout layout;
    protected final ProcessableFile file;
    protected final RecordSplitter splitter;
    protected final RecordBuilder builder;
    protected final byte[] workingArea;
    private long lastReadRecordNo = 0L;

    public FileCursor(TablespaceDefinition tablespaceDefinition, TableDefinition tableDefinition, ProcessableFile file) throws IOException, SQLException {
        super(tableDefinition);
        this.tablespaceDefinition = tablespaceDefinition;
        this.layout = tablespaceDefinition.getLayout();
        this.file = file;
        if (tablespaceDefinition.getTablespaceType() == TablespaceDefinition.TablespaceType.VSAM) {
            this.splitter = new SimpleRecordSplitter(this.layout, tableDefinition);
            this.builder = new SimpleRecordBuilder(this.layout, tableDefinition);
            int maximumRecordLength = file.getMaximumRecordLength();
            this.workingArea = new byte[maximumRecordLength];
        } else if (tablespaceDefinition.getTablespaceType() == TablespaceDefinition.TablespaceType.CSV) {
            this.workingArea = new byte[131072];
            this.splitter = new CSVRecordSplitter(tablespaceDefinition, tableDefinition);
            this.builder = new CSVRecordBuilder(tablespaceDefinition, tableDefinition);
        } else {
            throw new SQLException("Unsupported tablespace type");
        }
    }

    @Override
    public void updateFilter(ExpressionEvaluator conditionEvaluator) {
        super.updateFilter(conditionEvaluator);
        try {
            this.file.begin();
        }
        catch (Exception e) {
            Logger.getLogger(FileCursor.class.getName()).log(Level.SEVERE, "Failed to update filter", e);
        }
    }

    @Override
    public void reset() throws IOException, SQLException {
        super.reset();
        this.file.begin();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getName() {
        return this.layout.getFileName();
    }

    @Override
    public void update(Object[] data) throws IOException, SQLException {
        int byteCount = this.builder.build(this.workingArea, data);
        this.file.updateRecord(this.workingArea, byteCount);
    }

    @Override
    public boolean delete() throws IOException, SQLException {
        try {
            this.file.deleteLastReadRecord();
            return true;
        }
        catch (IOException e) {
            if (e.getMessage().contains("Trying to update an empty dataset")) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void insert(Object[] data) throws IOException, SQLException {
        int byteCount = this.builder.build(this.workingArea, data);
        try {
            this.file.writeRecord(this.workingArea, byteCount);
        }
        catch (ZFileException ex) {
            if (ex.getFeedbackRc() == 8) {
                String key = "";
                if (this.file.getKeyLength() != -1 && this.file.getKeyStartOffset() != -1) {
                    byte[] keyData = new byte[this.file.getKeyLength()];
                    System.arraycopy(this.workingArea, this.file.getKeyStartOffset(), keyData, 0, this.file.getKeyLength());
                    key = Hex.encodeHexString(keyData).toUpperCase();
                }
                throw new SQLException("Duplicate key on insert or update. Key = " + key, "23505", -803);
            }
            throw ex;
        }
    }

    @Override
    public Object[] next() throws IOException, SQLException {
        if (this.maxRowsToFetch >= 0L && this.rowsReturnedToCaller >= this.maxRowsToFetch) {
            Logger.getLogger(FileCursor.class.getName()).log(Level.FINE, "FileCursor returning no more rows because FETCH FIRST N ROWS ONLY has been reached");
            return null;
        }
        Object[] matchedRecord = null;
        do {
            int readByteCount = this.file.readRecord(this.workingArea);
            ++this.lastReadRecordNo;
            if (readByteCount == 0 && this.tablespaceDefinition.getTablespaceType() == TablespaceDefinition.TablespaceType.CSV) continue;
            if (readByteCount == -1) {
                return null;
            }
            matchedRecord = this.matchesFilter(this.splitter.split(this.lastReadRecordNo, Arrays.copyOfRange(this.workingArea, 0, readByteCount)));
        } while (matchedRecord == null);
        ++this.rowsReturnedToCaller;
        return matchedRecord;
    }

    @Override
    public void close() throws IOException {
        FileManager.getDefault().close(this.file.getUUID());
    }

    public ProcessableFile getFile() {
        return this.file;
    }
}

