/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.command.sql;

import de.ubs.jdbcserver.RecordTransformer;
import de.ubs.jdbcserver.ScratchPadManager;
import de.ubs.jdbcserver.command.AbstractServerCommand;
import de.ubs.jdbcserver.command.UniqueConnectionIdentifier;
import de.ubs.jdbcserver.cursor.Cursor;
import de.ubs.jdbcserver.jdbccomm.ResultSetAction;
import de.ubs.jdbcserver.jdbccomm.transport.Transportable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class ResultSetCommand
extends AbstractServerCommand {
    public ResultSetCommand(UniqueConnectionIdentifier connectionId, Document doc) {
        super(connectionId, doc);
    }

    @Override
    public Element execute() throws Exception {
        Element root = this.doc.getRootElement();
        ResultSetAction action = ResultSetAction.valueOf(root.getAttributeValue("action"));
        switch (action) {
            case CLOSE: {
                return this.closeResultSet(root);
            }
            case NEXT: {
                return this.nextRow(root);
            }
        }
        throw new RuntimeException("Unsupported result set action: " + (Object)((Object)action));
    }

    private Element closeResultSet(Element root) throws IOException {
        UUID resultSetUUID = UUID.fromString(root.getAttributeValue("uuid"));
        Cursor cursor = ScratchPadManager.getDefault().get(this.connectionId, resultSetUUID, Cursor.class);
        if (cursor != null) {
            cursor.close();
        }
        int count = ScratchPadManager.getDefault().removeAll(this.connectionId, resultSetUUID);
        Logger.getLogger(ResultSetCommand.class.getName()).log(Level.FINER, "Removed all ({0}) resources for result set {1}", new Object[]{count, resultSetUUID.toString()});
        return new Element("dummy");
    }

    private Element nextRow(Element root) throws IOException, SQLException {
        UUID resultSetUUID = UUID.fromString(root.getAttributeValue("uuid"));
        UUID connectionUUID = UUID.fromString(root.getAttributeValue("connection-uuid"));
        Integer fetchSize = Integer.valueOf(root.getAttributeValue("record-count", "1"));
        Logger.getLogger(ResultSetCommand.class.getName()).log(Level.FINER, "Use fetch size of {0}", fetchSize);
        ArrayList<Object[]> objectArrayList = new ArrayList<Object[]>();
        Cursor cursor = ScratchPadManager.getDefault().get(this.connectionId, resultSetUUID, Cursor.class);
        RecordTransformer transformer = ScratchPadManager.getDefault().get(this.connectionId, resultSetUUID, RecordTransformer.class);
        boolean eof = false;
        do {
            Object[] data;
            if ((data = cursor.next()) == null) {
                eof = true;
                continue;
            }
            objectArrayList.add(transformer.getOnlySelectedColumns(data));
        } while (!eof && objectArrayList.size() < fetchSize);
        Element dataElement = new Element("data");
        if (!objectArrayList.isEmpty()) {
            Transportable t = ScratchPadManager.getDefault().get(this.connectionId, connectionUUID, Transportable.class);
            String packedData = t.serialize(objectArrayList);
            dataElement.setText(packedData);
        }
        if (eof) {
            dataElement.setAttribute("eof", "true");
        }
        return dataElement;
    }
}

