/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.command.sql;

import de.ubs.jdbcserver.command.sql.PreparedContext;
import de.ubs.jdbcserver.evaluation.ExpressionEvaluator;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.jdbccommons.sql.parser.StatementInformation;
import java.sql.SQLException;

public class PreparedUpdateContext
extends PreparedContext {
    private int[] columnIndexes;
    private SQLParserParser.UpdateStatementContext updateCtx;

    public PreparedUpdateContext(StatementInformation statementInformation) throws SQLException {
        this(statementInformation, statementInformation.getTable(), statementInformation.getStatementInformation().updateStatement());
    }

    private PreparedUpdateContext(StatementInformation statementInformation, TableDefinition tableDefinition, SQLParserParser.UpdateStatementContext updateCtx) throws SQLException {
        super(new ExpressionEvaluator<Object>(tableDefinition, null, updateCtx));
        this.updateCtx = updateCtx;
        this.columnIndexes = new int[updateCtx.updateSpec().size()];
        for (int i = 0; i < updateCtx.updateSpec().size(); ++i) {
            String columnName = updateCtx.updateSpec((int)i).identifier().value;
            int indexOfColumn = tableDefinition.indexOfColumn(columnName);
            if (indexOfColumn == -1) {
                throw new SQLException(String.format("%s is not a column of table %s.%s", columnName, statementInformation.getTableSchema(), statementInformation.getTableName()), "42703", -205);
            }
            if (tableDefinition.getColumns().get(indexOfColumn).isReadOnly()) {
                throw new SQLException("The column " + columnName + " is not updateable", "42501", -551);
            }
            this.columnIndexes[i] = indexOfColumn;
        }
    }

    void updateData(Object[] data) throws SQLException {
        for (int i = 0; i < this.columnIndexes.length; ++i) {
            data[this.columnIndexes[i]] = this.visitor.evaluate(this.updateCtx.updateSpec(i).sum());
        }
    }
}

