/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.command.file;

import com.ibm.jzos.CatalogSearch;
import com.ibm.jzos.CatalogSearchField;
import com.ibm.jzos.Format1DSCB;
import com.ibm.jzos.PdsDirectory;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import de.ubs.jdbcserver.command.AbstractServerCommand;
import de.ubs.jdbcserver.command.UniqueConnectionIdentifier;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class ListDatasetCommand
extends AbstractServerCommand {
    private static final String FIELD_VOLSER = "VOLSER";
    private static final String FIELD_ENTNAME = "ENTNAME";
    private static final String FIELD_LRECL = "LRECL";

    public ListDatasetCommand(UniqueConnectionIdentifier connectionId, Document doc) {
        super(connectionId, doc);
    }

    @Override
    public Element execute() throws Exception {
        Element root = this.doc.getRootElement();
        String dsn = root.getAttributeValue("dsn");
        boolean isPds = Boolean.parseBoolean(root.getAttributeValue("pds"));
        Element resultElement = new Element("result");
        if (isPds) {
            PdsDirectory dir = new PdsDirectory(dsn);
            Iterator iter = dir.iterator();
            while (iter.hasNext()) {
                PdsDirectory.MemberInfo info = (PdsDirectory.MemberInfo)iter.next();
                resultElement.addContent(new Element("pds").setText(info.getName()));
            }
            dir.close();
        } else {
            CatalogSearch searcher = new CatalogSearch(dsn, 64000);
            searcher.addFieldName(FIELD_ENTNAME);
            searcher.addFieldName(FIELD_VOLSER);
            searcher.addFieldName(FIELD_LRECL);
            searcher.search();
            while (searcher.hasNext()) {
                CatalogSearch.Entry entry = (CatalogSearch.Entry)searcher.next();
                if (!entry.isDatasetEntry()) continue;
                CatalogSearchField entryNameField = entry.getField(FIELD_ENTNAME);
                CatalogSearchField volumeField = entry.getField(FIELD_VOLSER);
                CatalogSearchField lreclField = entry.getField(FIELD_LRECL);
                Element entryElement = new Element("entry");
                String fdsn = entryNameField.getFString().trim();
                entryElement.setText(fdsn);
                int lrecl = lreclField.getInt();
                if (volumeField.getFString() != null) {
                    String volume = volumeField.getFString().trim();
                    entryElement.setAttribute("volume", volume);
                    if (lrecl == -1) {
                        try {
                            Format1DSCB dscb = ZFile.obtainDSN("//'" + fdsn, volume + "'");
                            lrecl = dscb.getDS1LRECL();
                            entryElement.setAttribute("pds", String.valueOf(512 == dscb.getDS1DSORG()));
                        }
                        catch (RcException e) {
                            Logger.getLogger(ListDatasetCommand.class.getName()).log(Level.SEVERE, "DSCB obtaion returned rc = {0} {1}", new Object[]{e.getRc(), e.getMessage()});
                        }
                    }
                }
                if (lrecl != -1) {
                    entryElement.setAttribute("lrecl", String.valueOf(lrecl));
                }
                resultElement.addContent(entryElement);
            }
        }
        return resultElement;
    }
}

