/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.accessor.mainframe;

import com.ibm.jzos.fields.BinaryAsBigDecimalField;
import de.ubs.jdbcserver.accessor.AbstractDataAccessor;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.sql.SQLException;

public class VaryingStringAccessor
extends AbstractDataAccessor<String> {
    private final Charset charset;
    private final CharsetEncoder encoder;
    private final CharBuffer charBuffer;
    private final ByteBuffer byteBuffer;
    private BinaryAsBigDecimalField lengthField;
    private int lengthFieldLength = 0;
    private int lastLength = -1;

    public VaryingStringAccessor(Field field, int position, int lengthFieldLength, Charset charset) {
        super(field, position);
        this.charset = charset;
        this.encoder = charset.newEncoder();
        this.lengthFieldLength = lengthFieldLength;
        this.lengthField = new BinaryAsBigDecimalField(position, lengthFieldLength, 0, false);
        this.charBuffer = CharBuffer.allocate(this.field.getLength());
        this.byteBuffer = ByteBuffer.allocate(this.field.getLength());
    }

    @Override
    public int getLastLength() {
        return this.lastLength;
    }

    @Override
    public String get(byte[] input, int offset) throws SQLException {
        BigDecimal strLength = this.lengthField.getBigDecimal(input, offset);
        this.lastLength = strLength.intValue() + this.lengthFieldLength;
        return new String(input, this.position + offset + this.lengthFieldLength, strLength.intValue(), this.charset);
    }

    @Override
    public void put(String data, byte[] output, int offset) throws SQLException {
        try {
            byte[] bytes = data.getBytes(this.charset);
            this.lengthField.putBigDecimal(new BigDecimal(bytes.length), output, this.position + offset);
            System.arraycopy(bytes, 0, output, this.position + offset + this.lengthFieldLength, bytes.length);
            this.lastLength = this.lengthFieldLength + bytes.length;
        }
        catch (RuntimeException e) {
            throw new SQLException(String.format("Character conversion cannot be performed because a string cannot be converted from %s to %s", Charset.forName("UTF-8").name(), this.charset.name()), "22021", -331);
        }
    }
}

