/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.accessor.mainframe;

import de.ubs.jdbcserver.accessor.AbstractDataAccessor;
import de.ubs.jdbcserver.accessor.mainframe.StringAccessor;
import de.ubs.jdbcserver.accessor.mainframe.TimestampFormatter;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;

public class TimestampAccessor
extends AbstractDataAccessor<Timestamp> {
    private final StringAccessor accessor;
    private final TimestampFormatter dateFormat;

    public TimestampAccessor(Field field, int position, Charset encoding, String timestampPattern) {
        super(field, position);
        this.accessor = new StringAccessor(field, position, encoding);
        this.dateFormat = new TimestampFormatter(timestampPattern);
    }

    @Override
    public Timestamp get(byte[] input, int offset) throws SQLException {
        String timestampStr = this.accessor.get(input, offset);
        try {
            Timestamp timestamp = this.dateFormat.parse(timestampStr);
            return timestamp;
        }
        catch (ParseException ex) {
            throw new SQLException("Failed to parse timestamp: " + ex.getMessage(), "42601", -104);
        }
    }

    @Override
    public void put(Timestamp data, byte[] output, int offset) throws SQLException {
        String timestampStr = this.dateFormat.format(data);
        this.accessor.put(timestampStr, output, offset);
    }
}

