/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.accessor.mainframe;

import de.ubs.jdbcserver.accessor.AbstractDataAccessor;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.util.ComparableByteArray;
import java.sql.SQLException;

public class BinaryAccessor
extends AbstractDataAccessor<ComparableByteArray> {
    private final int length;
    private int lastLength = -1;

    public BinaryAccessor(Field field, int position, int length) {
        super(field, position);
        this.length = length;
    }

    @Override
    public ComparableByteArray get(byte[] input, int offset) throws SQLException {
        int readLength = this.length;
        if (this.getField().getName().equals("REMAINING_BYTES")) {
            this.lastLength = readLength = input.length - (this.position + offset);
        }
        byte[] b = new byte[readLength];
        System.arraycopy(input, this.position + offset, b, 0, readLength);
        return new ComparableByteArray(b);
    }

    @Override
    public void put(ComparableByteArray bytes, byte[] output, int offset) throws SQLException {
        byte[] input = bytes.getByteArray();
        if (input != null) {
            System.arraycopy(input, 0, output, this.position + offset, Math.min(input.length, this.length));
            if (this.getField().getName().equals("REMAINING_BYTES")) {
                this.lastLength = input.length;
            } else if (input.length < this.length) {
                for (int i = 0; i < this.length - input.length; ++i) {
                    output[this.position + offset + input.length + i] = 0;
                }
                this.lastLength = -1;
            }
        } else {
            this.lastLength = this.length;
        }
    }

    @Override
    public int getLastLength() {
        return this.lastLength;
    }
}

