/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.accessor;

import de.ubs.jdbcserver.accessor.DataAccessor;
import de.ubs.jdbcserver.accessor.mainframe.BinaryAccessor;
import de.ubs.jdbcserver.accessor.mainframe.BinaryNumberAccessor;
import de.ubs.jdbcserver.accessor.mainframe.DoubleAccessor;
import de.ubs.jdbcserver.accessor.mainframe.ExternalDecimalAccessor;
import de.ubs.jdbcserver.accessor.mainframe.ExternalFloatAccessor;
import de.ubs.jdbcserver.accessor.mainframe.FloatAccessor;
import de.ubs.jdbcserver.accessor.mainframe.PackedDecimalAccessor;
import de.ubs.jdbcserver.accessor.mainframe.StringAccessor;
import de.ubs.jdbcserver.accessor.mainframe.TerminatedStringAccessor;
import de.ubs.jdbcserver.accessor.mainframe.TimestampAccessor;
import de.ubs.jdbcserver.accessor.mainframe.VaryingStringAccessor;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccommons.struct.MainframeDataTypes;
import java.nio.charset.Charset;

public class AccessorFactory {
    public static DataAccessor[] create(TablespaceLayout layout, TableDefinition definition) {
        int position = 0;
        DataAccessor[] accessor = new DataAccessor[definition.getColumns().size()];
        for (int i = 0; i < definition.getColumns().size(); ++i) {
            ColumnDefinition columnDefinition = definition.getColumns().get(i);
            Field field = layout.getField(columnDefinition.getFieldPath());
            Charset fieldEncoding = field.getEncoding() != null ? field.getEncoding() : layout.getDefaultStringEncoding();
            String timestampPattern = columnDefinition.getTimestampPattern();
            if (null != timestampPattern) {
                accessor[i] = new TimestampAccessor(field, position, fieldEncoding, timestampPattern);
            } else {
                MainframeDataTypes type = MainframeDataTypes.valueOf(field.getType());
                if (type == MainframeDataTypes.STRING && columnDefinition.getType() == -2) {
                    type = MainframeDataTypes.BINARY;
                }
                switch (type) {
                    case PACKED_DECIMAL: {
                        accessor[i] = new PackedDecimalAccessor(position, field, true);
                        break;
                    }
                    case UNSIGNED_PACKED_DECIMAL: {
                        accessor[i] = new PackedDecimalAccessor(position, field, false);
                        break;
                    }
                    case VARYING2: {
                        accessor[i] = new VaryingStringAccessor(field, position, 2, fieldEncoding);
                        break;
                    }
                    case NULL_TERMINATED_STRING: {
                        accessor[i] = new TerminatedStringAccessor(field, position, 0, fieldEncoding);
                        break;
                    }
                    case VARYING4: {
                        accessor[i] = new VaryingStringAccessor(field, position, 4, fieldEncoding);
                        break;
                    }
                    case STRING: {
                        accessor[i] = new StringAccessor(field, position, layout.getDefaultStringEncoding());
                        break;
                    }
                    case EXTERNAL_DECIMAL: {
                        accessor[i] = new ExternalDecimalAccessor(position, field, layout.getDefaultStringEncoding());
                        break;
                    }
                    case EXTERNAL_FLOAT: {
                        accessor[i] = new ExternalFloatAccessor(position, field);
                        break;
                    }
                    case FLOAT: {
                        accessor[i] = new FloatAccessor(field, position);
                        break;
                    }
                    case DOUBLE: {
                        accessor[i] = new DoubleAccessor(field, position);
                        break;
                    }
                    case BINARY: {
                        accessor[i] = new BinaryAccessor(field, position, field.getLength());
                        break;
                    }
                    case SHORT: 
                    case INTEGER: 
                    case LONG: {
                        accessor[i] = new BinaryNumberAccessor(position, field, true);
                        break;
                    }
                    case UNSIGNED_SHORT: 
                    case UNSIGNED_INTEGER: 
                    case UNSIGNED_LONG: {
                        accessor[i] = new BinaryNumberAccessor(position, field, false);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unsupported type " + (Object)((Object)type)));
                    }
                }
            }
            position += field.getLength();
        }
        return accessor;
    }
}

