/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver;

import de.ubs.jdbcserver.CommandServer;
import de.ubs.jdbcserver.LogRecordFormatter;
import de.ubs.jdbcserver.jdbccommons.struct.CatalogManager;
import de.ubs.jdbcserver.jdbccommons.struct.PermissionManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class Server {
    public static final int DEFAULT_SERVER_PORT = 5000;
    private static final FastDateFormat TIMESTAMP_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd-HH.mm.ss.SSS");
    private static Level defaultLogLevel = Level.INFO;
    private static Server instance = null;
    private static CommandLine cmd = null;
    private static String buildDate = null;
    private CommandServer commandServer = null;
    private Thread commandServerThread = null;

    private Server() {
    }

    public static String getServerBuildDate() {
        if (buildDate == null) {
            URLClassLoader ucl;
            URL url;
            buildDate = "0";
            ClassLoader cl = Server.class.getClassLoader();
            if (cl instanceof URLClassLoader && (url = (ucl = (URLClassLoader)cl).findResource("META-INF/MANIFEST.MF")) != null) {
                try {
                    Manifest manifest = new Manifest(url.openStream());
                    Attributes attr = manifest.getMainAttributes();
                    String buildTime = attr.getValue("Build-Time");
                    if (buildTime != null) {
                        buildDate = buildTime.substring(0, 4) + buildTime.substring(5, 7) + buildTime.substring(8, 10);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return buildDate;
    }

    public static Server getInstance() {
        if (instance == null) {
            LogManager.getLogManager().getLogger("").setLevel(defaultLogLevel);
            for (Handler handler : LogManager.getLogManager().getLogger("").getHandlers()) {
                handler.setLevel(Level.ALL);
                handler.setFormatter(new LogRecordFormatter());
            }
            Logger.getLogger(Server.class.getName()).log(Level.INFO, "Java version: {0} ({1})", new Object[]{System.getProperty("java.version"), System.getProperty("java.vendor")});
            Logger.getLogger(Server.class.getName()).log(Level.INFO, "Operating system: {0} {1} ({2})", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")});
            Logger.getLogger(Server.class.getName()).log(Level.INFO, "Server build date: {0}", Server.getServerBuildDate());
            Logger.getLogger(Server.class.getName()).log(Level.INFO, "Server working directory: {0}", System.getProperty("user.dir"));
            Logger.getLogger(Server.class.getName()).log(Level.INFO, "Running under user ID: {0}", System.getProperty("user.name"));
            Logger.getLogger(Server.class.getName()).log(Level.INFO, "Default encoding: {0}", Charset.defaultCharset().displayName());
            Logger.getLogger(Server.class.getName()).log(Level.INFO, "Time zone for log messages: {0}", LogRecordFormatter.getLogRecordTimeZone().getDisplayName());
            instance = new Server();
            instance.postConstructor();
        }
        return instance;
    }

    private static boolean processParameters(String[] args) throws GeneralSecurityException, IOException {
        String value;
        Options options = Server.getOptions();
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException ex) {
            System.out.println(ex.getMessage());
            cmd = null;
        }
        if (cmd == null || cmd.hasOption('h')) {
            new HelpFormatter().printHelp("JDBCServer", options);
            return false;
        }
        if (cmd.hasOption('u')) {
            PermissionManager.getDefault().setSuperUser(cmd.getOptionValue('u'));
        }
        if (cmd.hasOption('w')) {
            PermissionManager.getDefault().setSuperUserPassword(cmd.getOptionValue('w'));
        }
        if (cmd.hasOption('l')) {
            defaultLogLevel = Level.parse(cmd.getOptionValue('l'));
        }
        if (cmd.hasOption('t')) {
            LogRecordFormatter.setLogRecordTimeZone(TimeZone.getTimeZone(cmd.getOptionValue('t')));
        }
        if (cmd.hasOption('e')) {
            CommandServer.setMaxListenErrors(Integer.parseInt(cmd.getOptionValue('e')));
        }
        if (cmd.hasOption('d')) {
            CommandServer.setListenDelay(Integer.parseInt(cmd.getOptionValue('d')));
        }
        if (cmd.hasOption('o')) {
            CommandServer.setPrintWtoMessages(true);
        }
        if (cmd.hasOption('c') && StringUtils.isNotEmpty(value = cmd.getOptionValue('c'))) {
            CommandServer.setCertificate(value);
        }
        if (cmd.hasOption('k') && StringUtils.isNotEmpty(value = cmd.getOptionValue('k'))) {
            CommandServer.setPrivateKey(value);
        }
        if (cmd.hasOption("cf") && StringUtils.isNotEmpty(value = cmd.getOptionValue("cf"))) {
            CommandServer.setCertificate(FileUtils.readFileToString(new File(value), StandardCharsets.UTF_8));
        }
        if (cmd.hasOption("kf") && StringUtils.isNotEmpty(value = cmd.getOptionValue("kf"))) {
            CommandServer.setPrivateKey(FileUtils.readFileToString(new File(value), StandardCharsets.UTF_8));
        }
        return true;
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("p", "port", true, "TCP port for incoming connections");
        options.addOption("u", "superuser", true, "User name of superuser");
        options.addOption("w", "password", true, "Password of superuser (Non-MVS only)");
        options.addOption("l", "loglevel", true, "Verbosity of log messages");
        options.addOption("t", "logtz", true, "Time zone for log messages");
        options.addOption("h", "help", false, "Print usage notes");
        options.addOption("e", "maxerrors", true, "Error threshold for server shutdown when accepting connections");
        options.addOption("d", "delay", true, "Time in seconds before reattempting to accept connections");
        options.addOption("o", "wto", false, "Print WTO messages when server starts and ends (MVS only)");
        options.addOption("c", "certificate", true, "SSL certificate");
        options.addOption("k", "privatekey", true, "SSL private key");
        options.addOption("cf", "certificatefile", true, "SSL certificate file");
        options.addOption("kf", "privatekeyfile", true, "SSL private key file");
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTimestamp(Date timestamp) {
        String ret;
        FastDateFormat fastDateFormat = TIMESTAMP_FORMAT;
        synchronized (fastDateFormat) {
            ret = TIMESTAMP_FORMAT.format(timestamp);
        }
        return ret;
    }

    private static int logLevelToNumber(String ll) {
        switch (ll = ll.trim().toUpperCase()) {
            case "ERROR": {
                return Level.SEVERE.intValue();
            }
            case "WARNING": {
                return Level.WARNING.intValue();
            }
            case "VERBOSE": {
                return Level.FINE.intValue();
            }
            case "DEBUG": {
                return Level.ALL.intValue();
            }
        }
        return Level.INFO.intValue();
    }

    public static void main(String[] args) throws GeneralSecurityException, IOException {
        ArrayList<String> sanitizedArgs = new ArrayList<String>();
        for (String s : args) {
            if (s.toUpperCase().startsWith("USER=")) {
                sanitizedArgs.add("-u");
                sanitizedArgs.add(s.substring(s.indexOf(61) + 1));
                continue;
            }
            if (s.toUpperCase().startsWith("LOG-LEVEL=") || s.toUpperCase().startsWith("LOGLEVEL=")) {
                sanitizedArgs.add("-l");
                sanitizedArgs.add(Integer.toString(Server.logLevelToNumber(s.substring(s.indexOf(61) + 1))));
                continue;
            }
            if (s.toUpperCase().startsWith("PASSWORD=")) {
                sanitizedArgs.add("-w");
                sanitizedArgs.add(s.substring(s.indexOf(61) + 1));
                continue;
            }
            sanitizedArgs.add(s);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Server.getInstance().commandServer.requestShutdown();
            try {
                Server.getInstance().commandServerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Logger.getLogger(Server.class.getName()).log(Level.INFO, "Shutdown complete");
        }));
        if (Server.processParameters(sanitizedArgs.toArray(new String[0]))) {
            Server.getInstance().go();
        }
    }

    private void postConstructor() {
        Logger.getLogger(Server.class.getName()).log(Level.INFO, "Initialize catalog");
        CatalogManager.getDefault();
        Logger.getLogger(Server.class.getName()).log(Level.INFO, "Initialize permission manager");
        PermissionManager.getDefault();
        Logger.getLogger(Server.class.getName()).log(Level.INFO, "Super user: {0}", PermissionManager.getDefault().getSuperUser());
    }

    private void go() {
        Logger.getLogger(Server.class.getName()).log(Level.INFO, "Server started (secured={0})", CommandServer.getSecured());
        int serverPort = 5000;
        try {
            serverPort = Integer.parseInt(cmd.getOptionValue("p"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.commandServer = new CommandServer(serverPort);
        this.commandServerThread = new Thread(this.commandServer);
        this.commandServerThread.setName("listener-thread");
        this.commandServerThread.start();
    }
}

