/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver;

import de.ubs.jdbcserver.jdbccomm.util.CommonUtils;
import de.ubs.jdbcserver.jdbccommons.struct.AbstractDatabaseEngine;
import de.ubs.jdbcserver.jdbccommons.struct.PermissionManager;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jdom2.JDOMException;

public class GenericDatabaseEngine
extends AbstractDatabaseEngine {
    private static final File ROOT = new File(System.getProperty("user.dir") + File.separator + "directory");

    private static File getTablespaceFile(String tablespaceName) {
        return new File(ROOT + File.separator + tablespaceName + ".xml");
    }

    @Override
    public void loadPermissions(PermissionManager pm) throws IOException {
    }

    @Override
    public void writePermissions(PermissionManager pm) throws IOException {
    }

    @Override
    public boolean isApplicable() {
        return !CommonUtils.isZos();
    }

    @Override
    public void dropTablespace(TablespaceDefinition ts) throws IOException {
        GenericDatabaseEngine.getTablespaceFile(ts.getName()).delete();
    }

    @Override
    public List<TablespaceDefinition> getTablespaces() throws IOException {
        LinkedList<TablespaceDefinition> tablespaces = new LinkedList<TablespaceDefinition>();
        for (String file : ROOT.list()) {
            if (!file.endsWith(".xml") || file.equals("SYSAUTH.xml")) continue;
            try {
                tablespaces.add(this.readTablespace(file.substring(0, file.length() - 4)));
            }
            catch (IOException | ParseException | JDOMException ex) {
                Logger.getLogger(GenericDatabaseEngine.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Logger.getLogger(GenericDatabaseEngine.class.getName()).log(Level.INFO, "Read {0} registered member from repository", tablespaces.size());
        return tablespaces;
    }

    @Override
    protected String read(String tablespaceName) throws IOException {
        File file = GenericDatabaseEngine.getTablespaceFile(tablespaceName);
        Logger.getLogger(GenericDatabaseEngine.class.getName()).log(Level.FINE, String.format("Reading definition of tablespace %s from file %s", tablespaceName, file.getAbsolutePath()));
        return FileUtils.readFileToString(file, StandardCharsets.UTF_8);
    }

    @Override
    protected void write(String tablespaceName, String content) throws IOException {
        File file = GenericDatabaseEngine.getTablespaceFile(tablespaceName);
        Logger.getLogger(GenericDatabaseEngine.class.getName()).log(Level.FINE, String.format("Writing definition of tablespace %s to file %s", tablespaceName, file.getAbsolutePath()));
        FileUtils.writeStringToFile(file, content, StandardCharsets.UTF_8);
    }

    static {
        ROOT.mkdirs();
    }
}

