/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver;

import de.ubs.jdbcserver.AuthenticationHandler;
import de.ubs.jdbcserver.ScratchPadManager;
import de.ubs.jdbcserver.Server;
import de.ubs.jdbcserver.command.ServerCommand;
import de.ubs.jdbcserver.command.ServerCommandProvider;
import de.ubs.jdbcserver.command.UniqueConnectionIdentifier;
import de.ubs.jdbcserver.jdbccomm.transport.OptimizedXmlSerializer;
import de.ubs.jdbcserver.jdbccomm.util.CommonUtils;
import de.ubs.jdbcserver.jdbccomm.util.XmlUtils;
import de.ubs.jdbcserver.jdbccommons.struct.PermissionManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.digest.DigestUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class CommandServerInstance
implements Runnable {
    private static final Object synchronizer = new Object();
    private static Integer lastConnectionId = 1;
    private boolean endOfSession = false;
    private Socket socket;
    private DataInputStream dataInputStream = null;
    private DataOutputStream dataOutputStream = null;
    private String authorizedUser = null;
    private String authorizedPassword = null;
    private UniqueConnectionIdentifier uniqueConnectionId;
    private OptimizedXmlSerializer serializer = new OptimizedXmlSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandServerInstance(Socket socket) {
        try {
            this.socket = socket;
            this.dataInputStream = new DataInputStream(socket.getInputStream());
            this.dataOutputStream = new DataOutputStream(socket.getOutputStream());
            this.socket.setSoTimeout(Integer.MAX_VALUE);
            this.socket.setTcpNoDelay(true);
            Object object = synchronizer;
            synchronized (object) {
                Integer n = lastConnectionId;
                lastConnectionId = lastConnectionId + 1;
                this.uniqueConnectionId = new UniqueConnectionIdentifier(n);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CommandServerInstance.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private Subject authenticate(Element root) throws LoginException {
        this.authorizedUser = root.getAttributeValue("user");
        this.authorizedPassword = root.getAttributeValue("password");
        LoginContext lc = new LoginContext("jdbc-server", new AuthenticationHandler(this.authorizedUser, this.authorizedPassword));
        lc.login();
        Logger.getLogger(CommandServerInstance.class.getName()).log(Level.INFO, "User {0} logged in", this.authorizedUser);
        return lc.getSubject();
    }

    private void processCommand(byte[] commandXml) {
        Exception exception = null;
        ServerCommand r = null;
        Element replyElement = null;
        try {
            Document doc = this.toXML(commandXml);
            ServiceLoader<ServerCommandProvider> serviceLoader = ServiceLoader.load(ServerCommandProvider.class);
            Iterator<ServerCommandProvider> iterator = serviceLoader.iterator();
            while (iterator.hasNext() && replyElement == null) {
                ServerCommandProvider serverCommandProvider = iterator.next();
                if (!serverCommandProvider.canHandleCommand(doc)) continue;
                r = serverCommandProvider.newInstance(this.uniqueConnectionId, doc);
                r.setUser(this.authorizedUser);
                r.setPassword(this.authorizedPassword);
                replyElement = r.execute();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CommandServerInstance.class.getName()).log(Level.INFO, ex.getMessage());
            exception = ex;
        }
        catch (Exception ex) {
            Logger.getLogger(CommandServerInstance.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            exception = ex;
        }
        Element root = null;
        root = exception != null ? this.createExceptionReplyElement(r, exception) : (replyElement == null ? this.createInvalidCommandReplyElement() : this.createSuccessReplyElement(replyElement));
        this.sendReply(root);
    }

    private Element createInvalidCommandReplyElement() {
        Element root = new Element("reply");
        root.setAttribute("time", Server.formatTimestamp(new Date(System.currentTimeMillis())));
        root.setAttribute("status", "invalid");
        return root;
    }

    private Element createSuccessReplyElement(Element replyElement) {
        Element root = new Element("reply");
        root.setAttribute("time", Server.formatTimestamp(new Date(System.currentTimeMillis())));
        root.setAttribute("status", "ok");
        if (replyElement != null) {
            root.addContent(replyElement);
        }
        return root;
    }

    private Element createExceptionReplyElement(ServerCommand r, Exception exception) {
        Element root = new Element("reply");
        root.setAttribute("time", Server.formatTimestamp(new Date(System.currentTimeMillis())));
        root.setAttribute("status", "exception");
        if (r != null) {
            root.setAttribute("uuid", r.getUuid().toString());
        }
        root.addContent(XmlUtils.createExceptionElement(exception));
        return root;
    }

    private void sendReply(Element root) {
        try {
            byte[] bytes = this.serializer.serializeXml(new Document(root));
            Logger.getLogger(CommandServerInstance.class.getName()).log(Level.FINER, "Send reply with {0} bytes", bytes.length);
            if (Logger.getLogger(CommandServerInstance.class.getName()).isLoggable(Level.FINEST)) {
                Logger.getLogger(CommandServerInstance.class.getName()).log(Level.FINEST, new String(bytes, StandardCharsets.UTF_8));
            }
            CommonUtils.writeUTF(this.dataOutputStream, bytes);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (RuntimeException ex) {
            Logger.getLogger(CommandServerInstance.class.getName()).log(Level.SEVERE, "Unable to serialize reply", ex);
            throw ex;
        }
    }

    private Document toXML(byte[] commandXml) throws IOException, JDOMException {
        try {
            Document document = this.serializer.deserializeXml(commandXml);
            return document;
        }
        catch (RuntimeException ex) {
            Logger.getLogger(CommandServerInstance.class.getName()).log(Level.SEVERE, "Unable to deserialize command", ex);
            throw ex;
        }
    }

    @Override
    public void run() {
        block11: {
            try {
                byte[] command;
                try {
                    this.validateCommunicationToken();
                    command = CommonUtils.read(this.dataInputStream);
                    if (command.length == 0) {
                        throw new IOException("Incorrect protocol");
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(CommandServerInstance.class.getName()).log(Level.FINE, "The client has terminated the session before authenticating" + (ex.getMessage() == null ? "" : " (" + ex.getMessage() + ")"));
                    this.endOfSession = true;
                    this.socket.close();
                    return;
                }
                Element root = this.toXML(command).getRootElement();
                if (root.getName().equals("authenticate")) {
                    Element metaInfoElement = new Element("metainfo");
                    String serverName = String.format("UBS File Bridge Server on %s", System.getProperty("os.name"));
                    String serverBuildDate = Server.getServerBuildDate();
                    metaInfoElement.setAttribute("database-product-name", serverName);
                    metaInfoElement.setAttribute("database-product-version", serverBuildDate == null ? "(unknown version)" : serverBuildDate);
                    if (CommonUtils.isZos()) {
                        Subject subject = this.authenticate(root);
                        this.sendReply(this.createSuccessReplyElement(metaInfoElement));
                        Subject.doAs(subject, new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                CommandServerInstance.this.go();
                                return null;
                            }
                        });
                    } else {
                        this.authorizedUser = root.getAttributeValue("user");
                        this.authorizedPassword = root.getAttributeValue("password");
                        if (!DigestUtils.sha256Hex(this.authorizedPassword).equals(PermissionManager.getDefault().getSuperUserPassword())) {
                            throw new RuntimeException("User/Password invalid");
                        }
                        this.sendReply(this.createSuccessReplyElement(metaInfoElement));
                        this.go();
                    }
                    break block11;
                }
                throw new RuntimeException("Authentication is required first");
            }
            catch (Exception e) {
                Element root = this.createExceptionReplyElement(null, e);
                this.sendReply(root);
            }
        }
        try {
            this.socket.close();
        }
        catch (IOException ex) {
            Logger.getLogger(CommandServerInstance.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void validateCommunicationToken() throws IOException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<IOException> future = executor.submit(() -> {
            try {
                byte[] communicationTokenBuffer = new byte["FILEBRIDGE_COMM_V_1_0_0".length()];
                try {
                    this.dataInputStream.readFully(communicationTokenBuffer);
                    String readCommunicationToken = new String(communicationTokenBuffer, "UTF-8");
                    if (!readCommunicationToken.equals("FILEBRIDGE_COMM_V_1_0_0")) {
                        this.throwCommunicationTokenError(readCommunicationToken);
                    }
                }
                catch (EOFException e) {
                    this.throwCommunicationTokenError("<not enough bytes>");
                }
            }
            catch (IOException e) {
                return e;
            }
            return null;
        });
        try {
            IOException throwable = future.get(70L, TimeUnit.SECONDS);
            if (throwable != null) {
                throw throwable;
            }
        }
        catch (TimeoutException e) {
            this.throwCommunicationTokenError("TimeoutException: " + e.getMessage());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void throwCommunicationTokenError(String readCommunicationToken) throws IOException {
        String message = "Invalid communication token: " + readCommunicationToken + ", expected token: " + "FILEBRIDGE_COMM_V_1_0_0";
        this.dataOutputStream.writeBytes(message);
        throw new IOException(message);
    }

    private void go() {
        try {
            while (!this.endOfSession) {
                try {
                    byte[] commandXml = CommonUtils.read(this.dataInputStream);
                    this.processCommand(commandXml);
                }
                catch (EOFException | SocketException ex) {
                    Logger.getLogger(CommandServerInstance.class.getName()).log(Level.INFO, "Client has closed connection");
                    this.endOfSession = true;
                }
                catch (IOException ex) {
                    Logger.getLogger(CommandServerInstance.class.getName()).log(Level.SEVERE, null, ex);
                    this.endOfSession = true;
                }
            }
            Logger.getLogger(CommandServerInstance.class.getName()).log(Level.INFO, "Session ended normally");
        }
        finally {
            ScratchPadManager.getDefault().cleanup(this.uniqueConnectionId);
        }
    }
}

